/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.block.entity;

import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.common.machine.PipeHost;
import li.cil.tis3d.common.machine.PipeImpl;
import li.cil.tis3d.util.WorldUtils;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public abstract class AbstractComputerBlockEntity
extends class_2586
implements PipeHost {
    private static final Face[][] FACE_MAPPING = new Face[][]{{Face.X_POS, Face.X_NEG, Face.Z_NEG, Face.Z_POS}, {Face.X_POS, Face.X_NEG, Face.Z_POS, Face.Z_NEG}, {Face.X_POS, Face.X_NEG, Face.Y_POS, Face.Y_NEG}, {Face.X_NEG, Face.X_POS, Face.Y_POS, Face.Y_NEG}, {Face.Z_NEG, Face.Z_POS, Face.Y_POS, Face.Y_NEG}, {Face.Z_POS, Face.Z_NEG, Face.Y_POS, Face.Y_NEG}};
    private static final Port[][] PORT_MAPPING = new Port[][]{{Port.DOWN, Port.DOWN, Port.DOWN, Port.DOWN}, {Port.UP, Port.UP, Port.UP, Port.UP}, {Port.RIGHT, Port.LEFT, Port.DOWN, Port.UP}, {Port.RIGHT, Port.LEFT, Port.UP, Port.DOWN}, {Port.RIGHT, Port.LEFT, Port.RIGHT, Port.RIGHT}, {Port.RIGHT, Port.LEFT, Port.LEFT, Port.LEFT}};
    private static final String TAG_PIPES = "pipes";
    private final PipeImpl[] pipes = new PipeImpl[Face.VALUES.length * Port.VALUES.length];
    private final AbstractComputerBlockEntity[] neighbors = new AbstractComputerBlockEntity[Face.VALUES.length];
    private final PipeImpl[] pipeOverride = new PipeImpl[this.pipes.length];

    AbstractComputerBlockEntity(class_2591 type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        for (Face face : Face.VALUES) {
            for (Port port : Port.VALUES) {
                int pipeIndex = AbstractComputerBlockEntity.pack(face, port);
                this.pipeOverride[pipeIndex] = this.pipes[pipeIndex] = new PipeImpl(this, face, AbstractComputerBlockEntity.mapFace(face, port), AbstractComputerBlockEntity.mapPort(face, port));
            }
        }
    }

    private static Face mapFace(Face face, Port port) {
        return FACE_MAPPING[face.ordinal()][port.ordinal()];
    }

    private static Port mapPort(Face face, Port port) {
        return PORT_MAPPING[face.ordinal()][port.ordinal()];
    }

    private static int pack(Face face, Port port) {
        return face.ordinal() * Port.VALUES.length + port.ordinal();
    }

    private static int packMapped(Face face, Port port) {
        return AbstractComputerBlockEntity.mapFace(face, port).ordinal() * Port.VALUES.length + AbstractComputerBlockEntity.mapPort(face, port).ordinal();
    }

    private static Port flipSide(Face face, Port port) {
        if (face == Face.Y_NEG || face == Face.Y_POS) {
            return port == Port.UP || port == Port.DOWN ? port.getOpposite() : port;
        }
        return port == Port.LEFT || port == Port.RIGHT ? port.getOpposite() : port;
    }

    public void onChunkUnload() {
    }

    void stepPipes() {
        for (PipeImpl pipe : this.pipes) {
            pipe.step();
        }
    }

    public Pipe[] getPipes() {
        return this.pipes;
    }

    public Pipe getReceivingPipe(Face face, Port port) {
        return this.pipeOverride[AbstractComputerBlockEntity.pack(face, port)];
    }

    public Pipe getSendingPipe(Face face, Port port) {
        return this.pipeOverride[AbstractComputerBlockEntity.packMapped(face, port)];
    }

    @Override
    public class_1937 getPipeHostWorld() {
        return Objects.requireNonNull(this.method_10997());
    }

    @Override
    public class_2338 getPipeHostPosition() {
        return Objects.requireNonNull(this.method_11016());
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("_client")) {
            this.fromClientTag(nbt);
        } else {
            this.readFromNBTForServer(nbt);
        }
    }

    public void method_11007(class_2487 nbtIn) {
        super.method_11007(nbtIn);
        class_2960 identifier = class_2591.method_11033((class_2591)this.method_11017());
        class_2487 nbt = nbtIn;
        if (identifier == null) {
            throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug.");
        }
        nbt.method_10582("id", identifier.toString());
        nbt.method_10569("x", this.field_11867.method_10263());
        nbt.method_10569("y", this.field_11867.method_10264());
        nbt.method_10569("z", this.field_11867.method_10260());
        this.writeToNBTForServer(nbt);
    }

    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        this.toClientTag(nbt);
        nbt.method_10556("_client", true);
        return nbt;
    }

    public void checkNeighbors() {
        class_1937 world = Objects.requireNonNull(this.method_10997());
        for (class_2350 facing : class_2350.values()) {
            class_2338 neighborPos = this.method_11016().method_10093(facing);
            if (WorldUtils.isBlockLoaded((class_1936)world, neighborPos)) {
                class_2586 blockEntity = world.method_8321(neighborPos);
                if (blockEntity instanceof AbstractComputerBlockEntity) {
                    this.setNeighbor(Face.fromDirection(facing), (AbstractComputerBlockEntity)blockEntity);
                    continue;
                }
                this.setNeighbor(Face.fromDirection(facing), null);
                continue;
            }
            this.setNeighbor(Face.fromDirection(facing), null);
        }
    }

    protected abstract void scheduleScan();

    protected void setNeighbor(Face face, @Nullable AbstractComputerBlockEntity neighbor) {
        AbstractComputerBlockEntity oldNeighbor = this.neighbors[face.ordinal()];
        if (neighbor != oldNeighbor) {
            this.neighbors[face.ordinal()] = neighbor;
            this.scheduleScan();
        }
    }

    protected void readFromNBTForServer(class_2487 nbt) {
        class_2499 pipesNbt = nbt.method_10554(TAG_PIPES, 10);
        int pipeCount = Math.min(pipesNbt.size(), this.pipes.length);
        for (int i = 0; i < pipeCount; ++i) {
            this.pipes[i].readFromNBT(pipesNbt.method_10602(i));
        }
        this.readFromNBTCommon(nbt);
    }

    protected void writeToNBTForServer(class_2487 nbt) {
        class_2499 pipesNbt = new class_2499();
        for (PipeImpl pipe : this.pipes) {
            class_2487 portNbt = new class_2487();
            pipe.writeToNBT(portNbt);
            pipesNbt.add((Object)portNbt);
        }
        nbt.method_10566(TAG_PIPES, (class_2520)pipesNbt);
        this.writeToNBTCommon(nbt);
    }

    public void fromClientTag(class_2487 nbt) {
        this.readFromNBTCommon(nbt);
    }

    public class_2487 toClientTag(class_2487 nbt) {
        this.writeToNBTCommon(nbt);
        return nbt;
    }

    protected void readFromNBTCommon(class_2487 nbt) {
    }

    protected void writeToNBTCommon(class_2487 nbt) {
    }

    boolean hasNeighbor(Face face) {
        return this.neighbors[face.ordinal()] != null;
    }

    void rebuildOverrides() {
        System.arraycopy(this.pipes, 0, this.pipeOverride, 0, this.pipes.length);
        for (Face face : Face.VALUES) {
            if (this.neighbors[face.ordinal()] != null) continue;
            for (Port port : Port.VALUES) {
                Face otherFace = AbstractComputerBlockEntity.mapFace(face, port);
                Port otherPort = AbstractComputerBlockEntity.mapPort(face, port);
                AbstractComputerBlockEntity neighbor = this.neighbors[otherFace.ordinal()];
                if (neighbor == null) continue;
                Face neighborFace = otherFace.getOpposite();
                Port neighborPort = AbstractComputerBlockEntity.flipSide(otherFace, otherPort);
                neighbor.computePipeOverrides(neighborFace, neighborPort, this, face, port);
            }
        }
    }

    private void computePipeOverrides(Face face, Port port, AbstractComputerBlockEntity start, Face startFace, Port startPort) {
        if (start == this) {
            return;
        }
        Face otherFace = AbstractComputerBlockEntity.mapFace(face, port);
        Port otherPort = AbstractComputerBlockEntity.mapPort(face, port);
        AbstractComputerBlockEntity neighbor = this.neighbors[otherFace.ordinal()];
        if (neighbor != null) {
            Face neighborFace = otherFace.getOpposite();
            Port neighborPort = AbstractComputerBlockEntity.flipSide(otherFace, otherPort);
            neighbor.computePipeOverrides(neighborFace, neighborPort, start, startFace, startPort);
        } else {
            int receivingIndex = AbstractComputerBlockEntity.pack(startFace, startPort);
            int mySendingIndex = AbstractComputerBlockEntity.packMapped(otherFace, otherPort);
            start.pipeOverride[receivingIndex] = this.pipes[mySendingIndex];
        }
    }
}

