/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.manual.segment;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Optional;
import li.cil.tis3d.client.manual.segment.BasicTextSegment;
import li.cil.tis3d.client.manual.segment.InteractiveSegment;
import li.cil.tis3d.client.manual.segment.Segment;
import li.cil.tis3d.client.render.font.NormalFontRenderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_327;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public final class CodeSegment
extends BasicTextSegment {
    private static final float FONT_SCALE = 0.5f;
    private static final int OFFSET_Y = 1;
    private final Segment parent;
    private final String text;

    public CodeSegment(Segment parent, String text) {
        this.parent = parent;
        this.text = text;
    }

    @Override
    public Segment parent() {
        return this.parent;
    }

    @Override
    protected String text() {
        return this.text;
    }

    @Override
    public Optional<InteractiveSegment> render(class_4587 matrices, int x, int y, int indent, int maxWidth, class_327 renderer, int mouseX, int mouseY) {
        int currentX = x + indent;
        int currentY = y + 1;
        String chars = this.text();
        int wrapIndent = this.computeWrapIndent(renderer);
        int numChars = this.maxChars(chars, maxWidth - indent, maxWidth - wrapIndent, renderer);
        while (chars.length() > 0) {
            String part = chars.substring(0, numChars);
            GlStateManager._clearColor((float)0.25f, (float)0.3f, (float)0.5f, (float)1.0f);
            matrices.method_22903();
            matrices.method_22904((double)currentX, (double)currentY, 0.0);
            matrices.method_22905(0.5f, 0.5f, 0.5f);
            NormalFontRenderer.INSTANCE.drawString(part.toUpperCase());
            matrices.method_22909();
            currentX = x + wrapIndent;
            currentY += this.lineHeight(renderer);
            chars = chars.substring(numChars);
            chars = chars.substring(CodeSegment.indexOfFirstNonWhitespace(chars));
            numChars = this.maxChars(chars, maxWidth - wrapIndent, maxWidth - wrapIndent, renderer);
        }
        return Optional.empty();
    }

    @Override
    protected boolean ignoreLeadingWhitespace() {
        return false;
    }

    @Override
    protected int stringWidth(String s, class_327 renderer) {
        return (int)(0.5f * (float)s.length() * (float)(NormalFontRenderer.INSTANCE.getCharWidth() + 1));
    }

    @Override
    public String toString() {
        return String.format("`%s`", this.text());
    }
}

