/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import li.cil.tis3d.client.init.Textures;
import li.cil.tis3d.client.manual.Document;
import li.cil.tis3d.client.manual.segment.InteractiveSegment;
import li.cil.tis3d.client.manual.segment.Segment;
import li.cil.tis3d.common.API;
import li.cil.tis3d.common.api.ManualAPIImpl;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public final class ManualGui
extends class_437 {
    private static final int DOCUMENT_MAX_WIDTH = 220;
    private static final int DOCUMENT_MAX_HEIGHT = 176;
    private static final int SCROLL_POS_X = 250;
    private static final int SCROLL_POS_Y = 48;
    private static final int SCROLL_WIDTH = 26;
    private static final int SCROLL_HEIGHT = 180;
    private static final int TAB_POS_X = -52;
    private static final int TAB_POS_Y = 40;
    private static final int TAB_WIDTH = 64;
    private static final int TAB_HEIGHT = 32;
    private static final int TAB_OVERLAP = 8;
    private static final int MAX_TABS_PER_SIDE = 7;
    private static final int WINDOW_WIDTH = 256;
    private static final int WINDOW_HEIGHT = 256;
    private int guiLeft = 0;
    private int guiTop = 0;
    private int xSize = 0;
    private int ySize = 0;
    private boolean isDragging = false;
    private Segment document = null;
    private int documentHeight = 0;
    private Optional<InteractiveSegment> currentSegment = Optional.empty();
    private final ArrayList<ImageButton> list = new ArrayList(7);
    private ImageButton scrollButton = null;

    protected ManualGui() {
        super((class_2561)new class_2585("Manual"));
    }

    public void pushPage(String path) {
        if (!ManualAPIImpl.peekPath().equals(path)) {
            ManualAPIImpl.pushPath(path);
            this.refreshPage();
        }
    }

    public void method_25426() {
        super.method_25426();
        assert (this.field_22787 != null);
        class_1041 window = this.field_22787.method_22683();
        ScaledResolution screenSize = new ScaledResolution(window.method_4486(), window.method_4502());
        ScaledResolution guiSize = new ScaledResolution(256, 256);
        int midX = screenSize.scaledWidth / 2;
        int midY = screenSize.scaledHeight / 2;
        this.guiLeft = midX - guiSize.scaledWidth / 2;
        this.guiTop = midY - guiSize.scaledHeight / 2;
        this.xSize = guiSize.scaledWidth;
        this.ySize = guiSize.scaledHeight;
        int i = 0;
        while (i < ManualAPIImpl.getTabs().size() && i < 7) {
            int x = this.guiLeft + -52;
            int y = this.guiTop + 40 + i * 24;
            int id = i++;
            this.list.add((ImageButton)this.method_37060((class_4068)new ImageButton(x, y, 64, 23, Textures.LOCATION_GUI_MANUAL_TAB, button -> API.manual.navigate(ManualAPIImpl.getTabs().get((int)id).path)).setImageHeight(32)));
        }
        this.scrollButton = new ImageButton(this.guiLeft + 250, this.guiTop + 48, 26, 13, Textures.LOCATION_GUI_MANUAL_SCROLL, button -> {}){

            public boolean method_25402(double x, double y, int button) {
                return false;
            }
        };
        this.method_37060((class_4068)this.scrollButton);
        this.refreshPage();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float partialTicks) {
        ImageButton button;
        ManualAPIImpl.Tab tab;
        int i;
        RenderSystem.enableBlend();
        super.method_25394(matrices, mouseX, mouseY, partialTicks);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)Textures.LOCATION_GUI_MANUAL_BACKGROUND);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ManualGui.method_25290((class_4587)matrices, (int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)256, (int)256);
        this.scrollButton.field_22763 = this.canScroll();
        this.scrollButton.hoverOverride = this.isDragging;
        for (i = 0; i < ManualAPIImpl.getTabs().size() && i < 7; ++i) {
            tab = ManualAPIImpl.getTabs().get(i);
            button = this.list.get(i);
            matrices.method_22903();
            tab.renderer.render(button.field_22760 + 25, button.field_22761 + 9 - 4);
            matrices.method_22909();
        }
        this.currentSegment = Document.render(matrices, this.document, this.guiLeft + 16, this.guiTop + 48, 220, 176, this.offset(), this.getTextRenderer(), mouseX, mouseY);
        if (!this.isDragging) {
            this.currentSegment.flatMap(InteractiveSegment::tooltip).ifPresent(t -> this.method_25424(matrices, (class_2561)new class_2588(t), mouseX, mouseY));
            for (i = 0; i < ManualAPIImpl.getTabs().size() && i < 7; ++i) {
                tab = ManualAPIImpl.getTabs().get(i);
                button = this.list.get(i);
                if (mouseX <= button.field_22760 || mouseX >= button.field_22760 + button.method_25368() || mouseY <= button.field_22761 || mouseY >= button.field_22761 + button.method_25364() || tab.tooltip == null) continue;
                this.method_25424(matrices, (class_2561)new class_2588(tab.tooltip), mouseX, mouseY);
            }
        }
        if (this.canScroll() && (this.isCoordinateOverScrollBar(mouseX - this.guiLeft, mouseY - this.guiTop) || this.isDragging)) {
            this.method_25424(matrices, class_2561.method_30163((String)(100 * this.offset() / this.maxOffset() + "%")), this.guiLeft + 250 + 26, this.scrollButton.field_22761 + this.scrollButton.method_25364() + 1);
        }
    }

    public boolean method_25401(double mx, double my, double value) {
        if (value != 0.0) {
            this.scroll(-value);
        }
        return true;
    }

    public boolean method_25404(int code, int scancode, int mods) {
        if (this.field_22787 == null) {
            return super.method_25404(code, scancode, mods);
        }
        if (this.field_22787.field_1690.field_1903.method_1417(code, scancode)) {
            this.popPage();
            return true;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(code, scancode)) {
            assert (this.field_22787.field_1724 != null);
            this.field_22787.field_1724.method_3137();
            return true;
        }
        return super.method_25404(code, scancode, mods);
    }

    public boolean method_25402(double mouseXd, double mouseYd, int button) {
        System.out.println("Hello World!");
        if (super.method_25402(mouseXd, mouseYd, button)) {
            return true;
        }
        int mouseX = (int)Math.round(mouseXd);
        int mouseY = (int)Math.round(mouseYd);
        if (this.canScroll() && button == 0 && this.isCoordinateOverScrollBar(mouseX - this.guiLeft, mouseY - this.guiTop)) {
            this.isDragging = true;
            this.scrollMouse(mouseYd);
            return true;
        }
        if (button == 0) {
            this.currentSegment.ifPresent(s -> s.onMouseClick(mouseX, mouseY));
            return true;
        }
        if (button == 1) {
            this.popPage();
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseXd, double mouseYd, int clickedMouseButton, double da, double db) {
        if (super.method_25403(mouseXd, mouseYd, clickedMouseButton, da, db)) {
            return true;
        }
        if (this.isDragging) {
            this.scrollMouse(mouseYd);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        super.method_25406(mouseX, mouseY, button);
        if (button == 0) {
            this.isDragging = false;
        }
        return true;
    }

    public boolean method_25421() {
        return false;
    }

    private class_327 getTextRenderer() {
        return this.field_22793;
    }

    private boolean canScroll() {
        return this.maxOffset() > 0;
    }

    private int offset() {
        return ManualAPIImpl.peekOffset();
    }

    private int maxOffset() {
        return this.documentHeight - 176;
    }

    private void refreshPage() {
        Iterable<String> content = API.manual.contentFor(ManualAPIImpl.peekPath());
        this.document = Document.parse(content != null ? content : Collections.singletonList("Document not found: " + ManualAPIImpl.peekPath()));
        this.documentHeight = Document.height(this.document, 220, this.getTextRenderer());
        this.scrollTo(this.offset());
    }

    private void popPage() {
        if (ManualAPIImpl.getHistorySize() > 1) {
            ManualAPIImpl.popPath();
            this.refreshPage();
        } else if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.method_3137();
        }
    }

    private void scrollMouse(double mouseY) {
        this.scrollTo((int)Math.round((mouseY - (double)this.guiTop - 48.0 - 6.5) * (double)this.maxOffset() / 167.0));
    }

    private void scroll(double amount) {
        this.scrollTo(this.offset() + (int)Math.round((double)(Document.lineHeight(this.getTextRenderer()) * 3) * amount));
    }

    private void scrollTo(int row) {
        ManualAPIImpl.setOffset(Math.max(0, Math.min(this.maxOffset(), row)));
        int yMin = this.guiTop + 48;
        this.scrollButton.field_22761 = this.maxOffset() > 0 ? yMin + 167 * this.offset() / this.maxOffset() : yMin;
    }

    private boolean isCoordinateOverScrollBar(int x, int y) {
        return x > 250 && x < 276 && y >= 48 && y < 228;
    }

    private static class ImageButton
    extends class_4185 {
        private final class_2960 image;
        private boolean hoverOverride = false;
        private int imageHeightOverride = 0;

        ImageButton(int x, int y, int w, int h, class_2960 image, class_4185.class_4241 action) {
            super(x, y, w, h, class_2585.field_24366, action);
            this.image = image;
        }

        ImageButton setImageHeight(int height) {
            this.imageHeightOverride = height;
            return this;
        }

        public int method_25368() {
            return this.field_22758;
        }

        public int method_25364() {
            return this.field_22759;
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float partialTicks) {
            if (this.field_22764) {
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderTexture((int)0, (class_2960)this.image);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_22762 = mouseX >= this.field_22760 && mouseY >= this.field_22761 && mouseX < this.field_22760 + this.field_22758 && mouseY < this.field_22761 + this.field_22759;
                int x0 = this.field_22760;
                int x1 = this.field_22760 + this.field_22758;
                int verticalImageOffset = 0;
                int y0 = this.field_22761 + verticalImageOffset;
                int y1 = this.field_22761 + verticalImageOffset + (this.imageHeightOverride > 0 ? this.imageHeightOverride : this.field_22759);
                float u0 = 0.0f;
                float u1 = 1.0f;
                float v0 = this.hoverOverride || this.method_25367() ? 0.5f : 0.0f;
                float v1 = v0 + 0.5f;
                class_289 t = class_289.method_1348();
                class_287 b = t.method_1349();
                b.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
                b.method_22912((double)x0, (double)y1, (double)this.method_25305()).method_22913(0.0f, v1).method_1344();
                b.method_22912((double)x1, (double)y1, (double)this.method_25305()).method_22913(1.0f, v1).method_1344();
                b.method_22912((double)x1, (double)y0, (double)this.method_25305()).method_22913(1.0f, v0).method_1344();
                b.method_22912((double)x0, (double)y0, (double)this.method_25305()).method_22913(0.0f, v0).method_1344();
                t.method_1350();
            }
        }
    }

    private static class ScaledResolution {
        final int scaledWidth;
        final int scaledHeight;

        ScaledResolution(int width, int height) {
            int scaleFactor = 1;
            int guiScale = class_310.method_1551().field_1690.field_1868;
            if (guiScale == 0) {
                guiScale = 1000;
            }
            while (scaleFactor < guiScale && width / (scaleFactor + 1) >= 320 && height / (scaleFactor + 1) >= 240) {
                ++scaleFactor;
            }
            if (class_310.method_1551().method_1573() && scaleFactor % 2 != 0 && scaleFactor != 1) {
                --scaleFactor;
            }
            this.scaledWidth = class_3532.method_15384((double)((double)width / (double)scaleFactor));
            this.scaledHeight = class_3532.method_15384((double)((double)height / (double)scaleFactor));
        }
    }
}

