/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.util.collection;

import java.util.AbstractQueue;
import java.util.Iterator;

public class SimpleQueue<E>
extends AbstractQueue<E> {
    private static final int MINIMUM_CAPACITY = 16;
    private Object[] queue;
    private int size;
    private int head;
    private int tail;

    public SimpleQueue() {
        this(16);
    }

    public SimpleQueue(int initialCapacity) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("The value of initialCapacity must be greater than 0!");
        }
        this.queue = new Object[initialCapacity];
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.size == this.queue.length) {
            this.resize(this.size << 1);
        }
        this.queue[this.tail] = e;
        this.tail = this.incr(this.tail);
        ++this.size;
        return true;
    }

    @Override
    public E poll() {
        Object e = this.queue[this.head];
        if (e != null) {
            this.queue[this.head] = null;
            this.head = this.incr(this.head);
            --this.size;
            if (this.queue.length > 16 && this.size == this.queue.length >> 2) {
                this.resize(this.size << 1);
            }
        }
        return (E)e;
    }

    @Override
    public E peek() {
        Object e = this.queue[this.head];
        return (E)e;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    private void resize(int newSize) {
        Object[] oldQueue = this.queue;
        this.queue = new Object[newSize];
        int i = 0;
        if (this.head < this.tail) {
            int j = this.head;
            while (j < this.tail) {
                this.queue[i++] = oldQueue[j++];
            }
        } else {
            int j = this.head;
            while (j < oldQueue.length) {
                this.queue[i++] = oldQueue[j++];
            }
            j = 0;
            while (j < this.tail) {
                this.queue[i++] = oldQueue[j++];
            }
        }
        this.head = 0;
        this.tail = this.size;
    }

    private int incr(int i) {
        return ++i < this.queue.length ? i : 0;
    }
}

