/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.redstone;

import alternate.current.interfaces.mixin.IBlock;
import alternate.current.redstone.WireBlock;
import alternate.current.redstone.WireHandler;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3218;
import net.minecraft.class_4538;

public class WorldAccess {
    private final WireBlock wireBlock;
    private final class_3218 world;
    private final WireHandler wireHandler;

    public WorldAccess(WireBlock wireBlock, class_3218 world) {
        this.wireBlock = wireBlock;
        this.world = world;
        this.wireHandler = new WireHandler(this.wireBlock, this);
    }

    public WireHandler getWireHandler() {
        return this.wireHandler;
    }

    public class_2680 getBlockState(class_2338 pos) {
        int y = pos.method_10264();
        if (y < this.world.method_31607() || y >= this.world.method_31600()) {
            return class_2246.field_10243.method_9564();
        }
        int x = pos.method_10263();
        int z = pos.method_10260();
        int index = this.world.method_31602(y);
        class_2791 chunk = this.world.method_8402(x >> 4, z >> 4, class_2806.field_12803, true);
        class_2826 section = chunk.method_12006()[index];
        if (section == null) {
            return class_2246.field_10124.method_9564();
        }
        return section.method_12254(x & 0xF, y & 0xF, z & 0xF);
    }

    public boolean setWireState(class_2338 pos, class_2680 state) {
        int y = pos.method_10264();
        if (y < this.world.method_31607() || y >= this.world.method_31600()) {
            return false;
        }
        int x = pos.method_10263();
        int z = pos.method_10260();
        int index = this.world.method_31602(y);
        class_2791 chunk = this.world.method_8402(x >> 4, z >> 4, class_2806.field_12803, true);
        class_2826 section = chunk.method_12006()[index];
        if (section == null) {
            return false;
        }
        class_2680 prevState = section.method_16675(x & 0xF, y & 0xF, z & 0xF, state);
        if (state == prevState) {
            return false;
        }
        this.world.method_14178().method_14128(pos);
        ((class_2818)chunk).method_12220();
        return true;
    }

    public boolean breakBlock(class_2338 pos, class_2680 state) {
        class_2248.method_9497((class_2680)state, (class_1937)this.world, (class_2338)pos);
        return this.world.method_8652(pos, class_2246.field_10124.method_9564(), 2);
    }

    public void updateNeighborShape(class_2338 pos, class_2680 state, class_2350 fromDir, class_2338 fromPos, class_2680 fromState) {
        class_2680 newState = state.method_26191(fromDir, fromState, (class_1936)this.world, pos, fromPos);
        class_2248.method_30094((class_2680)state, (class_2680)newState, (class_1936)this.world, (class_2338)pos, (int)2);
    }

    public void updateNeighborBlock(class_2338 pos, class_2338 fromPos, class_2248 fromBlock) {
        this.getBlockState(pos).method_26181((class_1937)this.world, pos, fromBlock, fromPos, false);
    }

    public void updateNeighborBlock(class_2338 pos, class_2680 state, class_2338 fromPos, class_2248 fromBlock) {
        state.method_26181((class_1937)this.world, pos, fromBlock, fromPos, false);
    }

    public boolean isSolidBlock(class_2338 pos) {
        return this.getBlockState(pos).method_26212((class_1922)this.world, pos);
    }

    public boolean isSolidBlock(class_2338 pos, class_2680 state) {
        return state.method_26212((class_1922)this.world, pos);
    }

    public boolean emitsWeakPowerTo(class_2338 pos, class_2680 state, class_2350 dir) {
        return ((IBlock)state.method_26204()).emitsWeakPowerTo((class_1937)this.world, pos, state, dir);
    }

    public boolean emitsStrongPowerTo(class_2338 pos, class_2680 state, class_2350 dir) {
        return ((IBlock)state.method_26204()).emitsStrongPowerTo((class_1937)this.world, pos, state, dir);
    }

    public int getWeakPowerFrom(class_2338 pos, class_2680 state, class_2350 dir) {
        return state.method_26195((class_1922)this.world, pos, dir);
    }

    public int getStrongPowerFrom(class_2338 pos, class_2680 state, class_2350 dir) {
        return state.method_26203((class_1922)this.world, pos, dir);
    }

    public boolean shouldBreak(class_2338 pos, class_2680 state) {
        return !state.method_26184((class_4538)this.world, pos);
    }
}

