/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.redstone;

import alternate.current.redstone.Node;
import alternate.current.redstone.WireBlock;
import alternate.current.redstone.WireConnectionManager;
import alternate.current.redstone.WorldAccess;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class WireNode
extends Node {
    public final WireConnectionManager connections;
    public int currentPower;
    public int virtualPower;
    public int externalPower;
    public int flowIn;
    public int flowOut;
    public boolean shouldBreak;
    public boolean removed;
    public boolean prepared;
    public boolean inNetwork;

    public WireNode(WireBlock wireBlock, WorldAccess world, class_2338 pos, class_2680 state) {
        super(wireBlock, world);
        this.pos = pos.method_10062();
        this.state = state;
        this.connections = new WireConnectionManager(this);
        this.virtualPower = this.currentPower = this.wireBlock.getPower(this.world, this.pos, this.state);
    }

    @Override
    public Node update(class_2338 pos, class_2680 state) {
        throw new UnsupportedOperationException("Cannot update a WireNode!");
    }

    @Override
    public boolean isWire() {
        return true;
    }

    @Override
    public WireNode asWire() {
        return this;
    }

    public int nextPower() {
        return this.wireBlock.clampPower(this.virtualPower);
    }

    public boolean offerPower(int power, int iDir) {
        if (power == this.virtualPower) {
            this.flowIn |= 1 << iDir;
            return false;
        }
        if (power > this.virtualPower) {
            this.virtualPower = power;
            this.flowIn = 1 << iDir;
            return true;
        }
        return false;
    }

    public boolean updateState() {
        if (this.removed) {
            return true;
        }
        this.state = this.world.getBlockState(this.pos);
        if (this.shouldBreak) {
            return this.world.breakBlock(this.pos, this.state);
        }
        this.currentPower = this.wireBlock.clampPower(this.virtualPower);
        this.state = this.wireBlock.updatePowerState(this.world, this.pos, this.state, this.currentPower);
        return this.world.setWireState(this.pos, this.state);
    }
}

