/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.redstone;

import alternate.current.redstone.Node;
import alternate.current.redstone.PowerQueue;
import alternate.current.redstone.WireBlock;
import alternate.current.redstone.WireConnection;
import alternate.current.redstone.WireNode;
import alternate.current.redstone.WorldAccess;
import alternate.current.util.BlockUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class WireHandler {
    public static final int[] FLOW_IN_TO_FLOW_OUT = new int[]{-1, 0, 1, 1, 2, -1, 2, 1, 3, 0, -1, 0, 3, 3, 2, -1};
    private static final int[][] UPDATE_ORDER = new int[][]{{0, 2, 1, 3}, {1, 3, 2, 0}, {2, 0, 3, 1}, {3, 1, 0, 2}};
    private final WireBlock wireBlock;
    private final WorldAccess world;
    private final int minPower;
    private final int maxPower;
    private final int powerStep;
    private final List<WireNode> network;
    private final Long2ObjectMap<Node> nodes;
    private final Queue<WireNode> powerChanges;
    private int rootCount;
    private Node[] nodeCache;
    private int usedNodes;
    private boolean updatingPower;

    public WireHandler(WireBlock wireBlock, WorldAccess world) {
        this.wireBlock = wireBlock;
        this.world = world;
        this.minPower = this.wireBlock.getMinPower();
        this.maxPower = this.wireBlock.getMaxPower();
        this.powerStep = this.wireBlock.getPowerStep();
        this.network = new ArrayList<WireNode>();
        this.nodes = new Long2ObjectOpenHashMap();
        this.powerChanges = new PowerQueue(this.minPower, this.maxPower);
        this.nodeCache = new Node[16];
        this.fillNodeCache(0, 16);
    }

    private Node getOrAddNode(class_2338 pos) {
        return (Node)this.nodes.computeIfAbsent(pos.method_10063(), key -> this.getNextNode(pos));
    }

    private Node getNeighbor(Node node, int iDir) {
        Node neighbor = node.neighbors[iDir];
        if (neighbor == null) {
            class_2350 dir = Directions.ALL[iDir];
            node.neighbors[iDir] = neighbor = this.getOrAddNode(node.pos.method_10093(dir));
            neighbor.neighbors[Directions.iOpposite((int)iDir)] = node;
        }
        return neighbor;
    }

    private Node removeNode(class_2338 pos) {
        return (Node)this.nodes.remove(pos.method_10063());
    }

    private void filterNodes() {
        this.nodes.values().removeIf(node -> {
            if (node.isWire()) {
                WireNode wire = node.asWire();
                wire.prepared = false;
                wire.inNetwork = false;
                Arrays.fill(wire.neighbors, null);
                return false;
            }
            return true;
        });
    }

    private Node getNextNode(class_2338 pos) {
        class_2680 state = this.world.getBlockState(pos);
        if (this.wireBlock.isOf(state)) {
            return new WireNode(this.wireBlock, this.world, pos, state);
        }
        return this.getNextNode().update(pos, state);
    }

    private Node getNextNode() {
        if (this.usedNodes == this.nodeCache.length) {
            this.increaseNodeCache();
        }
        return this.nodeCache[this.usedNodes++];
    }

    private void increaseNodeCache() {
        Node[] oldCache = this.nodeCache;
        this.nodeCache = new Node[oldCache.length << 1];
        for (int index = 0; index < oldCache.length; ++index) {
            this.nodeCache[index] = oldCache[index];
        }
        this.fillNodeCache(oldCache.length, this.nodeCache.length);
    }

    private void fillNodeCache(int start, int end) {
        for (int index = start; index < end; ++index) {
            this.nodeCache[index] = new Node(this.wireBlock, this.world);
        }
    }

    public void onWireUpdated(class_2338 pos) {
        this.findRoots(pos, true);
        this.tryUpdatePower();
    }

    public void onWireAdded(class_2338 pos) {
        this.findRoots(pos, false);
        this.tryUpdatePower();
    }

    public void onWireRemoved(class_2338 pos) {
        WireNode wire;
        Node node = this.removeNode(pos);
        if (node == null || !node.isWire()) {
            wire = new WireNode(this.wireBlock, this.world, pos, this.wireBlock.asBlock().method_9564());
        } else {
            wire = node.asWire();
            if (wire.shouldBreak) {
                return;
            }
        }
        wire.removed = true;
        this.tryAddRoot(wire);
        this.tryUpdatePower();
    }

    private void findRoots(class_2338 pos, boolean checkNeighbors) {
        Node node = this.getOrAddNode(pos);
        if (!node.isWire()) {
            return;
        }
        WireNode wire = node.asWire();
        this.tryAddRoot(wire);
        if (!checkNeighbors || !wire.inNetwork || wire.connections.all.length == 0) {
            return;
        }
        for (int iDir = 0; iDir < Directions.ALL.length; ++iDir) {
            Node neighbor = this.getNeighbor(wire, iDir);
            if (neighbor.isSolidBlock()) {
                this.findRedstoneAround(neighbor, Directions.iOpposite(iDir));
                continue;
            }
            if (!this.world.emitsWeakPowerTo(neighbor.pos, neighbor.state, Directions.ALL[iDir])) continue;
            this.findRootsAroundRedstone(neighbor, Directions.iOpposite(iDir));
        }
    }

    private void findRedstoneAround(Node node, int ignore) {
        for (int iDir = 0; iDir < Directions.ALL.length; ++iDir) {
            if (iDir == ignore) continue;
            Node neighbor = this.getNeighbor(node, iDir);
            if (!this.world.emitsStrongPowerTo(neighbor.pos, neighbor.state, Directions.ALL[iDir])) continue;
            this.findRootsAroundRedstone(neighbor, -1);
        }
    }

    private void findRootsAroundRedstone(Node node, int ignore) {
        for (int iDir = 0; iDir < Directions.ALL.length; ++iDir) {
            if (iDir == ignore) continue;
            int iOpp = Directions.iOpposite(iDir);
            class_2350 opp = Directions.ALL[iOpp];
            boolean weak = this.world.emitsWeakPowerTo(node.pos, node.state, opp);
            boolean strong = this.world.emitsStrongPowerTo(node.pos, node.state, opp);
            if (!weak && !strong) continue;
            Node neighbor = this.getNeighbor(node, iDir);
            if (weak && neighbor.isWire()) {
                this.tryAddRoot(neighbor.asWire());
                continue;
            }
            if (!strong || !neighbor.isSolidBlock()) continue;
            this.findRootsAround(neighbor, iOpp);
        }
    }

    private void findRootsAround(Node node, int ignore) {
        for (int iDir = 0; iDir < Directions.ALL.length; ++iDir) {
            Node neighbor;
            if (iDir == ignore || !(neighbor = this.getNeighbor(node, iDir)).isWire()) continue;
            this.tryAddRoot(neighbor.asWire());
        }
    }

    private void tryAddRoot(WireNode wire) {
        if (wire.prepared) {
            return;
        }
        this.prepareWire(wire);
        this.findPower(wire, false);
        if (this.needsPowerChange(wire)) {
            this.network.add(wire);
            ++this.rootCount;
            if (wire.connections.flow >= 0) {
                wire.flowOut = wire.connections.flow;
            }
            wire.inNetwork = true;
        }
    }

    private void prepareWire(WireNode wire) {
        if (wire.prepared) {
            return;
        }
        wire.prepared = true;
        if (!wire.removed && !wire.shouldBreak && this.world.shouldBreak(wire.pos, wire.state)) {
            wire.shouldBreak = true;
        }
        this.findConnections(wire);
        wire.externalPower = wire.removed || wire.shouldBreak ? this.minPower : this.getExternalPower(wire);
        wire.virtualPower = wire.externalPower;
    }

    private void findConnections(WireNode wire) {
        wire.connections.clear();
        this.wireBlock.findWireConnections(wire, this::getNeighbor);
    }

    private int getExternalPower(WireNode wire) {
        int power = this.minPower;
        for (int iDir = 0; iDir < Directions.ALL.length; ++iDir) {
            Node neighbor = this.getNeighbor(wire, iDir);
            if (neighbor.isWire()) continue;
            if (neighbor.isSolidBlock()) {
                power = Math.max(power, this.getStrongPowerTo(neighbor, Directions.iOpposite(iDir)));
            }
            if (neighbor.isRedstoneComponent()) {
                power = Math.max(power, this.world.getWeakPowerFrom(neighbor.pos, neighbor.state, Directions.ALL[iDir]));
            }
            if (power < this.maxPower) continue;
            return this.maxPower;
        }
        return power;
    }

    private int getStrongPowerTo(Node node, int ignore) {
        int power = this.minPower;
        for (int iDir = 0; iDir < Directions.ALL.length; ++iDir) {
            Node neighbor;
            if (iDir == ignore || !(neighbor = this.getNeighbor(node, iDir)).isRedstoneComponent() || (power = Math.max(power, this.world.getStrongPowerFrom(neighbor.pos, neighbor.state, Directions.ALL[iDir]))) < this.maxPower) continue;
            return this.maxPower;
        }
        return power;
    }

    private void findPower(WireNode wire, boolean ignoreNetwork) {
        if (wire.removed || wire.shouldBreak || wire.externalPower >= this.maxPower - this.powerStep) {
            return;
        }
        wire.virtualPower = wire.externalPower;
        wire.flowIn = 0;
        this.findWirePower(wire, ignoreNetwork);
    }

    private void findWirePower(WireNode wire, boolean ignoreNetwork) {
        for (WireConnection connection : wire.connections.all) {
            if (!connection.in) continue;
            WireNode neighbor = connection.wire;
            if (ignoreNetwork && neighbor.inNetwork) continue;
            int power = Math.max(this.minPower, neighbor.virtualPower - this.powerStep);
            int iOpp = connection.iDir + 2 & 3;
            wire.offerPower(power, iOpp);
        }
    }

    private boolean needsPowerChange(WireNode wire) {
        return wire.removed || wire.shouldBreak || wire.virtualPower != wire.currentPower;
    }

    private void tryUpdatePower() {
        if (this.rootCount > 0) {
            this.updatePower();
        }
        this.usedNodes = 0;
        this.nodes.clear();
    }

    private void updatePower() {
        this.buildNetwork();
        this.findPoweredWires();
        this.rootCount = 0;
        this.network.clear();
        this.filterNodes();
        try {
            this.letPowerFlow();
        }
        catch (Throwable t) {
            this.updatingPower = false;
            throw t;
        }
    }

    private void buildNetwork() {
        for (int index = 0; index < this.network.size(); ++index) {
            WireNode wire = this.network.get(index);
            for (int iDir : UPDATE_ORDER[wire.flowOut]) {
                for (WireConnection connection : wire.connections.byDir[iDir]) {
                    if (!connection.out) continue;
                    WireNode neighbor = connection.wire;
                    if (neighbor.inNetwork) continue;
                    this.prepareWire(neighbor);
                    this.findPower(neighbor, false);
                    if (!this.needsPowerChange(neighbor)) continue;
                    this.addToNetwork(neighbor, iDir);
                }
            }
        }
    }

    private void addToNetwork(WireNode wire, int backupFlow) {
        this.network.add(wire);
        wire.inNetwork = true;
        wire.flowOut = backupFlow;
    }

    private void findPoweredWires() {
        for (int index = 0; index < this.network.size(); ++index) {
            WireNode wire = this.network.get(index);
            this.findPower(wire, true);
            if (index < this.rootCount || wire.removed || wire.shouldBreak || wire.virtualPower > this.minPower) {
                this.queuePowerChange(wire);
                continue;
            }
            --wire.virtualPower;
        }
    }

    private void queuePowerChange(WireNode wire) {
        if (this.needsPowerChange(wire)) {
            this.powerChanges.add(wire);
        } else {
            this.findPowerFlow(wire);
            this.transmitPower(wire);
        }
    }

    private void findPowerFlow(WireNode wire) {
        int flow = FLOW_IN_TO_FLOW_OUT[wire.flowIn];
        if (flow >= 0) {
            wire.flowOut = flow;
        } else if (wire.connections.flow >= 0) {
            wire.flowOut = wire.connections.flow;
        }
    }

    private void transmitPower(WireNode wire) {
        int nextPower = Math.max(this.minPower, wire.virtualPower - this.powerStep);
        for (int iDir : UPDATE_ORDER[wire.flowOut]) {
            for (WireConnection connection : wire.connections.byDir[iDir]) {
                if (!connection.out) continue;
                WireNode connectedWire = connection.wire;
                if (connectedWire.removed || connectedWire.shouldBreak || !connectedWire.offerPower(nextPower, iDir)) continue;
                this.queuePowerChange(connectedWire);
            }
        }
    }

    private void letPowerFlow() {
        if (this.updatingPower) {
            return;
        }
        this.updatingPower = true;
        while (!this.powerChanges.isEmpty()) {
            WireNode wire = this.powerChanges.poll();
            if (!this.needsPowerChange(wire)) continue;
            this.findPowerFlow(wire);
            if (wire.updateState()) {
                if (!wire.shouldBreak) {
                    this.updateNeighborShapes(wire);
                }
                this.updateNeighborBlocks(wire);
            }
            this.transmitPower(wire);
        }
        this.updatingPower = false;
    }

    private void updateNeighborShapes(WireNode wire) {
        class_2338 wirePos = wire.pos;
        class_2680 wireState = wire.state;
        for (class_2350 dir : BlockUtil.DIRECTIONS) {
            this.updateNeighborShape(wirePos.method_10093(dir), dir.method_10153(), wirePos, wireState);
        }
    }

    private void updateNeighborShape(class_2338 pos, class_2350 fromDir, class_2338 fromPos, class_2680 fromState) {
        class_2680 state = this.world.getBlockState(pos);
        if (!state.method_26215() && !this.wireBlock.isOf(state)) {
            this.world.updateNeighborShape(pos, state, fromDir, fromPos, fromState);
        }
    }

    private void updateNeighborBlocks(WireNode wire) {
        int iDir = wire.flowOut;
        class_2350 forward = Directions.HORIZONTAL[iDir];
        class_2350 rightward = Directions.HORIZONTAL[iDir + 1 & 3];
        class_2350 backward = Directions.HORIZONTAL[iDir + 2 & 3];
        class_2350 leftward = Directions.HORIZONTAL[iDir + 3 & 3];
        class_2350 downward = class_2350.field_11033;
        class_2350 upward = class_2350.field_11036;
        class_2338 front = wire.pos.method_10093(forward);
        class_2338 right = wire.pos.method_10093(rightward);
        class_2338 back = wire.pos.method_10093(backward);
        class_2338 left = wire.pos.method_10093(leftward);
        class_2338 below = wire.pos.method_10093(downward);
        class_2338 above = wire.pos.method_10093(upward);
        this.updateNeighbor(front, wire.pos);
        this.updateNeighbor(back, wire.pos);
        this.updateNeighbor(right, wire.pos);
        this.updateNeighbor(left, wire.pos);
        this.updateNeighbor(below, wire.pos);
        this.updateNeighbor(above, wire.pos);
        this.updateNeighbor(front.method_10093(rightward), wire.pos);
        this.updateNeighbor(back.method_10093(leftward), wire.pos);
        this.updateNeighbor(front.method_10093(leftward), wire.pos);
        this.updateNeighbor(back.method_10093(rightward), wire.pos);
        this.updateNeighbor(front.method_10093(downward), wire.pos);
        this.updateNeighbor(back.method_10093(upward), wire.pos);
        this.updateNeighbor(front.method_10093(upward), wire.pos);
        this.updateNeighbor(back.method_10093(downward), wire.pos);
        this.updateNeighbor(right.method_10093(downward), wire.pos);
        this.updateNeighbor(left.method_10093(upward), wire.pos);
        this.updateNeighbor(right.method_10093(upward), wire.pos);
        this.updateNeighbor(left.method_10093(downward), wire.pos);
        this.updateNeighbor(front.method_10093(forward), wire.pos);
        this.updateNeighbor(back.method_10093(backward), wire.pos);
        this.updateNeighbor(right.method_10093(rightward), wire.pos);
        this.updateNeighbor(left.method_10093(leftward), wire.pos);
        this.updateNeighbor(below.method_10093(downward), wire.pos);
        this.updateNeighbor(above.method_10093(upward), wire.pos);
    }

    private void updateNeighbor(class_2338 pos, class_2338 fromPos) {
        class_2680 state = this.world.getBlockState(pos);
        if (!state.method_26215() && !this.wireBlock.isOf(state)) {
            this.world.updateNeighborBlock(pos, state, fromPos, this.wireBlock.asBlock());
        }
    }

    public static class Directions {
        public static final class_2350[] ALL = new class_2350[]{class_2350.field_11039, class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11033, class_2350.field_11036};
        public static final class_2350[] HORIZONTAL = new class_2350[]{class_2350.field_11039, class_2350.field_11043, class_2350.field_11034, class_2350.field_11035};
        public static final int WEST = 0;
        public static final int NORTH = 1;
        public static final int EAST = 2;
        public static final int SOUTH = 3;
        public static final int DOWN = 4;
        public static final int UP = 5;

        public static int iOpposite(int iDir) {
            return iDir < 4 ? iDir + 2 & 3 : iDir + 1 & 5;
        }
    }
}

