/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.redstone;

import alternate.current.redstone.WireConnection;
import alternate.current.redstone.WireHandler;
import alternate.current.redstone.WireNode;
import java.util.Arrays;

public class WireConnectionManager {
    public static final int DEFAULT_MAX_UPDATE_DEPTH = 512;
    public final WireNode wire;
    public WireConnection[] all;
    public final WireConnection[][] byDir;
    private int flowTotal;
    public int flow;

    public WireConnectionManager(WireNode wire) {
        this.wire = wire;
        this.all = new WireConnection[0];
        this.byDir = new WireConnection[WireHandler.Directions.HORIZONTAL.length][];
        this.clear();
    }

    public void clear() {
        this.all = new WireConnection[0];
        Arrays.fill((Object[])this.byDir, this.all);
    }

    public void add(WireNode wire, int iDir, boolean in, boolean out) {
        this.addConnection(new WireConnection(wire, iDir, in, out));
    }

    private void addConnection(WireConnection connection) {
        this.all = WireConnectionManager.withConnection(this.all, connection);
        WireConnection[] connections = this.byDir[connection.iDir];
        this.byDir[connection.iDir] = WireConnectionManager.withConnection(connections, connection);
        this.flowTotal |= 1 << connection.iDir;
        this.flow = WireHandler.FLOW_IN_TO_FLOW_OUT[this.flowTotal];
    }

    private static WireConnection[] withConnection(WireConnection[] connections, WireConnection connection) {
        WireConnection[] newArray = new WireConnection[connections.length + 1];
        for (int index = 0; index < connections.length; ++index) {
            newArray[index] = connections[index];
        }
        newArray[connections.length] = connection;
        return newArray;
    }
}

