/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.redstone;

import alternate.current.redstone.WireBlock;
import alternate.current.redstone.WireHandler;
import alternate.current.redstone.WireNode;
import alternate.current.redstone.WorldAccess;
import java.util.Arrays;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class Node {
    private static final int SOLID_BLOCK = 1;
    private static final int REDSTONE = 2;
    public final WireBlock wireBlock;
    public final WorldAccess world;
    public final Node[] neighbors;
    public class_2338 pos;
    public class_2680 state;
    private int flags;

    public Node(WireBlock wireBlock, WorldAccess world) {
        this.wireBlock = wireBlock;
        this.world = world;
        this.neighbors = new Node[WireHandler.Directions.ALL.length];
    }

    public boolean equals(Object o) {
        if (o instanceof Node) {
            Node node = (Node)o;
            return this.world == node.world && this.wireBlock == node.wireBlock && this.pos.equals((Object)node.pos);
        }
        return false;
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    public Node update(class_2338 pos, class_2680 state) {
        if (this.wireBlock.isOf(state)) {
            throw new IllegalStateException("Cannot update a regular Node to a WireNode!");
        }
        this.pos = pos.method_10062();
        this.state = state;
        this.flags = 0;
        Arrays.fill(this.neighbors, null);
        if (this.world.isSolidBlock(this.pos, this.state)) {
            this.flags |= 1;
        }
        if (this.state.method_26219()) {
            this.flags |= 2;
        }
        return this;
    }

    public boolean isOf(WireBlock wireBlock) {
        return this.wireBlock == wireBlock;
    }

    public boolean isWire() {
        return false;
    }

    public boolean isSolidBlock() {
        return (this.flags & 1) != 0;
    }

    public boolean isRedstoneComponent() {
        return (this.flags & 2) != 0;
    }

    public WireNode asWire() {
        throw new UnsupportedOperationException("Not a WireNode!");
    }
}

