/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.mixin;

import alternate.current.interfaces.mixin.IServerWorld;
import alternate.current.redstone.Node;
import alternate.current.redstone.WireBlock;
import alternate.current.redstone.WireHandler;
import alternate.current.redstone.WireNode;
import alternate.current.redstone.WorldAccess;
import java.util.function.BiFunction;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2457;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2457.class})
public abstract class RedstoneWireBlockMixin
implements WireBlock {
    @Inject(method={"update"}, cancellable=true, at={@At(value="HEAD")})
    private void onUpdate(class_1937 world, class_2338 pos, class_2680 state, CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"onBlockAdded"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/block/RedstoneWireBlock;update(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)V")})
    private void onOnBlockAddedInjectBeforeUpdate(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify, CallbackInfo ci) {
        ((IServerWorld)world).getAccess(this).getWireHandler().onWireAdded(pos);
        class_2680 newState = world.method_8320(pos);
        if (newState != state) {
            newState.method_30101((class_1936)world, pos, 2);
            newState.method_30102((class_1936)world, pos, 2);
        }
    }

    @Inject(method={"onStateReplaced"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/block/RedstoneWireBlock;update(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)V")})
    private void onOnStateReplacedInjectBeforeUpdate(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved, CallbackInfo ci) {
        ((IServerWorld)world).getAccess(this).getWireHandler().onWireRemoved(pos);
    }

    @Inject(method={"neighborUpdate"}, cancellable=true, at={@At(value="HEAD")})
    private void onNeighborUpdateInjectAtHead(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify, CallbackInfo ci) {
        if (!world.method_8608()) {
            ((IServerWorld)world).getAccess(this).getWireHandler().onWireUpdated(pos);
        }
        ci.cancel();
    }

    @Override
    public int getMinPower() {
        return 0;
    }

    @Override
    public int getMaxPower() {
        return 15;
    }

    @Override
    public int getPowerStep() {
        return 1;
    }

    @Override
    public int getPower(WorldAccess world, class_2338 pos, class_2680 state) {
        return (Integer)state.method_11654((class_2769)class_2741.field_12511);
    }

    @Override
    public class_2680 updatePowerState(WorldAccess world, class_2338 pos, class_2680 state, int power) {
        return (class_2680)state.method_11657((class_2769)class_2741.field_12511, (Comparable)Integer.valueOf(this.clampPower(power)));
    }

    @Override
    public void findWireConnections(WireNode wire, BiFunction<Node, Integer, Node> nodeProvider) {
        boolean belowIsSolid = nodeProvider.apply(wire, 4).isSolidBlock();
        boolean aboveIsSolid = nodeProvider.apply(wire, 5).isSolidBlock();
        for (int iDir = 0; iDir < WireHandler.Directions.HORIZONTAL.length; ++iDir) {
            Node node;
            Node neighbor = nodeProvider.apply(wire, iDir);
            if (neighbor.isWire()) {
                wire.connections.add(neighbor.asWire(), iDir, true, true);
                continue;
            }
            boolean sideIsSolid = neighbor.isSolidBlock();
            if (!sideIsSolid && (node = nodeProvider.apply(neighbor, 4)).isWire()) {
                wire.connections.add(node.asWire(), iDir, true, belowIsSolid);
            }
            if (aboveIsSolid || !(node = nodeProvider.apply(neighbor, 5)).isWire()) continue;
            wire.connections.add(node.asWire(), iDir, sideIsSolid, true);
        }
    }
}

