/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.hydrogen.common.collections;

import com.google.common.collect.Table;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import me.jellysquid.mods.hydrogen.common.collections.FastImmutableTableCache;
import org.apache.commons.lang3.ArrayUtils;

public class FastImmutableTable<R, C, V>
implements Table<R, C, V> {
    private R[] rowKeys;
    private int[] rowIndices;
    private final int rowMask;
    private final int rowCount;
    private C[] colKeys;
    private int[] colIndices;
    private final int colMask;
    private final int colCount;
    private V[] values;
    private final int size;

    public FastImmutableTable(Table<R, C, V> table, FastImmutableTableCache<R, C, V> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("Cache must not be null");
        }
        float loadFactor = 0.75f;
        Set rowKeySet = table.rowKeySet();
        Set colKeySet = table.columnKeySet();
        this.rowCount = rowKeySet.size();
        this.colCount = colKeySet.size();
        int rowN = HashCommon.arraySize((int)this.rowCount, (float)loadFactor);
        int colN = HashCommon.arraySize((int)this.colCount, (float)loadFactor);
        this.rowMask = rowN - 1;
        this.rowKeys = new Object[rowN];
        this.rowIndices = new int[rowN];
        this.colMask = colN - 1;
        this.colKeys = new Object[colN];
        this.colIndices = new int[colN];
        this.createIndex(this.colKeys, this.colIndices, this.colMask, colKeySet);
        this.createIndex(this.rowKeys, this.rowIndices, this.rowMask, rowKeySet);
        this.values = new Object[this.rowCount * this.colCount];
        for (Table.Cell cell : table.cellSet()) {
            int colIdx = this.getIndex(this.colKeys, this.colIndices, this.colMask, cell.getColumnKey());
            int rowIdx = this.getIndex(this.rowKeys, this.rowIndices, this.rowMask, cell.getRowKey());
            if (colIdx < 0 || rowIdx < 0) {
                throw new IllegalStateException("Missing index for " + cell);
            }
            this.values[this.colCount * rowIdx + colIdx] = cell.getValue();
        }
        this.size = table.size();
        this.rowKeys = cache.dedupRows(this.rowKeys);
        this.rowIndices = cache.dedupIndices(this.rowIndices);
        this.colIndices = cache.dedupIndices(this.colIndices);
        this.colKeys = cache.dedupColumns(this.colKeys);
        this.values = cache.dedupValues(this.values);
    }

    private <T> void createIndex(T[] keys, int[] indices, int mask, Collection<T> iterable) {
        int index = 0;
        for (T obj : iterable) {
            int i = this.find(keys, mask, obj);
            if (i >= 0) continue;
            int pos = -i - 1;
            keys[pos] = obj;
            indices[pos] = index++;
        }
    }

    private <T> int getIndex(T[] keys, int[] indices, int mask, T key) {
        int pos = this.find(keys, mask, key);
        if (pos < 0) {
            return -1;
        }
        return indices[pos];
    }

    public boolean contains(Object rowKey, Object columnKey) {
        return this.get(rowKey, columnKey) != null;
    }

    public boolean containsRow(Object rowKey) {
        return this.find(this.rowKeys, this.rowMask, rowKey) >= 0;
    }

    public boolean containsColumn(Object columnKey) {
        return this.find(this.colKeys, this.colMask, columnKey) >= 0;
    }

    public boolean containsValue(Object value) {
        return ArrayUtils.contains((Object[])this.values, (Object)value);
    }

    public V get(Object rowKey, Object columnKey) {
        int row = this.getIndex(this.rowKeys, this.rowIndices, this.rowMask, rowKey);
        int col = this.getIndex(this.colKeys, this.colIndices, this.colMask, columnKey);
        if (row < 0 || col < 0) {
            return null;
        }
        return this.values[this.colCount * row + col];
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public V put(R rowKey, C columnKey, V val) {
        throw new UnsupportedOperationException();
    }

    private <T> int find(T[] key, int mask, T value) {
        int pos = HashCommon.mix((int)value.hashCode()) & mask;
        T curr = key[pos];
        if (curr == null) {
            return -(pos + 1);
        }
        if (value.equals(curr)) {
            return pos;
        }
        do {
            if ((curr = key[pos = pos + 1 & mask]) != null) continue;
            return -(pos + 1);
        } while (!value.equals(curr));
        return pos;
    }

    public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        throw new UnsupportedOperationException();
    }

    public V remove(Object rowKey, Object columnKey) {
        throw new UnsupportedOperationException();
    }

    public Map<C, V> row(R rowKey) {
        throw new UnsupportedOperationException();
    }

    public Map<R, V> column(C columnKey) {
        throw new UnsupportedOperationException();
    }

    public Set<Table.Cell<R, C, V>> cellSet() {
        throw new UnsupportedOperationException();
    }

    public Set<R> rowKeySet() {
        throw new UnsupportedOperationException();
    }

    public Set<C> columnKeySet() {
        throw new UnsupportedOperationException();
    }

    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    public Map<R, Map<C, V>> rowMap() {
        throw new UnsupportedOperationException();
    }

    public Map<C, Map<R, V>> columnMap() {
        throw new UnsupportedOperationException();
    }
}

