/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.HydrogenEntrySet;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Map;

public class HydrogenImmutableReferenceHashMap<K, V>
extends ImmutableMap<K, V> {
    protected transient K[] key;
    protected transient V[] value;
    protected transient int mask;
    protected transient int size;

    public HydrogenImmutableReferenceHashMap() {
    }

    public HydrogenImmutableReferenceHashMap(Map<K, V> map) {
        this(map.size(), 0.75f);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.putInternal(entry.getKey(), entry.getValue());
        }
    }

    private HydrogenImmutableReferenceHashMap(int size, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (size < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        int n = HashCommon.arraySize((int)size, (float)loadFactor);
        this.key = new Object[n];
        this.value = new Object[n];
        this.mask = n - 1;
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    public V get(Object k) {
        int pos = HashCommon.mix((int)System.identityHashCode(k)) & this.mask;
        K curr = this.key[pos];
        if (curr == null) {
            return null;
        }
        if (k == curr) {
            return this.value[pos];
        }
        do {
            if ((curr = this.key[pos = pos + 1 & this.mask]) != null) continue;
            return null;
        } while (k != curr);
        return this.value[pos];
    }

    private void putInternal(K k, V v) {
        int pos = this.find(k);
        if (pos < 0) {
            int n = -pos - 1;
            this.key[n] = k;
            this.value[n] = v;
        } else {
            this.value[pos] = v;
        }
    }

    private int find(K k) {
        int pos = HashCommon.mix((int)System.identityHashCode(k)) & this.mask;
        K curr = this.key[pos];
        if (curr == null) {
            return -(pos + 1);
        }
        if (k == curr) {
            return pos;
        }
        do {
            if ((curr = this.key[pos = pos + 1 & this.mask]) != null) continue;
            return -(pos + 1);
        } while (k != curr);
        return pos;
    }

    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new HydrogenEntrySet<K, V>(this.key, this.value, this.size);
    }

    boolean isPartialView() {
        return false;
    }
}

