/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.dynamicsf.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.andre111.dynamicsf.config.ConfigHelper;
import me.andre111.dynamicsf.filter.ReverbFilter;
import net.minecraft.class_2960;

public class ConfigDataReverbFilter {
    public boolean enabled = true;
    public float reverbPercent = 1.0f;
    public int maxBlocks = 1024;
    public boolean checkSky = true;
    public List<String> dimensionBaseReverb = Arrays.asList("minecraft:the_nether;1.0");
    public List<String> customBlockReverb = new ArrayList<String>();
    public float density = 0.2f;
    public float diffusion = 0.6f;
    public float gain = 0.15f;
    public float gainHF = 0.8f;
    public float minDecayTime = 0.1f;
    public float decayHFRatio = 0.7f;
    public float airAbsorptionGainHF = 0.99f;
    public float reflectionsGainBase = 0.05f;
    public float reflectionsGainMultiplier = 0.05f;
    public float reflectionsDelayMultiplier = 0.025f;
    public float lateReverbGainBase = 1.26f;
    public float lateReverbGainMultiplier = 0.1f;
    public float lateReverbDelayMultiplier = 0.01f;
    private transient boolean cached = false;
    private transient Map<class_2960, Float> dimensionBaseReverbMap = new HashMap<class_2960, Float>();
    private transient Map<class_2960, ReverbFilter.Reverb> customBlockReverbMap = new HashMap<class_2960, ReverbFilter.Reverb>();

    private void calculateCache() {
        if (!this.cached) {
            this.dimensionBaseReverbMap = ConfigHelper.parseToMap(this.dimensionBaseReverb, class_2960::new, Float::parseFloat);
            this.customBlockReverbMap = ConfigHelper.parseToMap(this.customBlockReverb, class_2960::new, ReverbFilter.Reverb::fromName);
            this.cached = true;
        }
    }

    public void recalculateCache() {
        this.cached = false;
        this.calculateCache();
    }

    public float getDimensionBaseReverb(class_2960 dimension) {
        this.calculateCache();
        if (this.dimensionBaseReverbMap.containsKey(dimension)) {
            return this.dimensionBaseReverbMap.get(dimension).floatValue();
        }
        return 0.0f;
    }

    public ReverbFilter.Reverb getCustomBlockReverb(class_2960 block) {
        this.calculateCache();
        return this.customBlockReverbMap.get(block);
    }
}

