/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.collect.Sets;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.ModIdentification;

public class WailaExceptionHandler {
    private static final Set<IJadeProvider> ERRORS = Sets.newHashSet();
    private static final File ERROR_OUTPUT = new File("logs", "JadeErrorOutput.txt");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy - HH:mm:ss");

    public static void handleErr(Throwable e, @Nullable IJadeProvider provider, @Nullable ITooltip tooltip) {
        if (CommonProxy.isDevEnv()) {
            ExceptionUtils.rethrow((Throwable)e);
            return;
        }
        if (!ERRORS.contains(provider)) {
            ERRORS.add(provider);
            Jade.LOGGER.error("Caught unhandled exception : [{}] {}", (Object)provider, (Object)e);
            Jade.LOGGER.error("See JadeErrorOutput.txt for more information");
            try {
                FileUtils.writeStringToFile((File)ERROR_OUTPUT, (String)(DATE_FORMAT.format(new Date()) + "\n" + provider + "\n" + ExceptionUtils.getStackTrace((Throwable)e) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tooltip != null) {
            String modid = null;
            if (provider != null) {
                modid = provider.getUid().m_135827_();
            }
            if (modid == null || "minecraft".equals(modid)) {
                modid = "jade";
            }
            tooltip.add((Component)Component.m_237110_((String)"jade.error", (Object[])new Object[]{ModIdentification.getModName(modid)}).m_130940_(ChatFormatting.DARK_RED));
        }
    }
}

