/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.config;

import com.google.common.collect.Lists;
import com.google.gson.annotations.Expose;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.ModIdentification;

public class WailaConfig
implements IWailaConfig {
    private final ConfigGeneral general = new ConfigGeneral();
    private final ConfigOverlay overlay = new ConfigOverlay();
    private final ConfigFormatting formatting = new ConfigFormatting();

    @Override
    public ConfigGeneral getGeneral() {
        return this.general;
    }

    @Override
    public ConfigOverlay getOverlay() {
        return this.overlay;
    }

    @Override
    public ConfigFormatting getFormatting() {
        return this.formatting;
    }

    @Override
    public IPluginConfig getPlugin() {
        return PluginConfig.INSTANCE;
    }

    public static class ConfigGeneral
    implements IWailaConfig.IConfigGeneral {
        public static final List<String> itemModNameTooltipDisabledByMods = Lists.newArrayList((Object[])new String[]{"emi"});
        public boolean hintOverlayToggle = true;
        public boolean hintNarratorToggle = true;
        public boolean previewOverlay = true;
        private boolean displayTooltip = true;
        private boolean displayBlocks = true;
        private boolean displayEntities = true;
        private boolean displayBosses = true;
        private IWailaConfig.DisplayMode displayMode = IWailaConfig.DisplayMode.TOGGLE;
        private boolean hideFromDebug = true;
        private boolean hideFromTabList = true;
        private boolean enableTextToSpeech = false;
        private IWailaConfig.TTSMode ttsMode = IWailaConfig.TTSMode.PRESS;
        private IWailaConfig.FluidMode fluidMode = IWailaConfig.FluidMode.ANY;
        private float reachDistance = 0.0f;
        @Expose
        private boolean debug = false;
        private boolean itemModNameTooltip = true;
        private IWailaConfig.BossBarOverlapMode bossBarOverlapMode = IWailaConfig.BossBarOverlapMode.PUSH_DOWN;

        public static void init() {
            List<String> names = itemModNameTooltipDisabledByMods.stream().filter(CommonProxy::isModLoaded).map(ModIdentification::getModName).toList();
            itemModNameTooltipDisabledByMods.clear();
            itemModNameTooltipDisabledByMods.addAll(names);
        }

        @Override
        public void setDisplayTooltip(boolean displayTooltip) {
            this.displayTooltip = displayTooltip;
        }

        @Override
        public boolean getDisplayEntities() {
            return this.displayEntities;
        }

        @Override
        public void setDisplayEntities(boolean displayEntities) {
            this.displayEntities = displayEntities;
        }

        @Override
        public boolean getDisplayBlocks() {
            return this.displayBlocks;
        }

        @Override
        public void setDisplayBlocks(boolean displayBlocks) {
            this.displayBlocks = displayBlocks;
        }

        @Override
        public void setHideFromDebug(boolean hideFromDebug) {
            this.hideFromDebug = hideFromDebug;
        }

        @Override
        public void toggleTTS() {
            this.enableTextToSpeech = !this.enableTextToSpeech;
        }

        @Override
        public boolean shouldDisplayTooltip() {
            return this.displayTooltip;
        }

        @Override
        public IWailaConfig.DisplayMode getDisplayMode() {
            return this.displayMode;
        }

        @Override
        public void setDisplayMode(IWailaConfig.DisplayMode displayMode) {
            this.displayMode = displayMode;
        }

        @Override
        public boolean shouldHideFromDebug() {
            return this.hideFromDebug;
        }

        @Override
        public boolean shouldEnableTextToSpeech() {
            return this.ttsMode == IWailaConfig.TTSMode.TOGGLE && this.enableTextToSpeech;
        }

        @Override
        public IWailaConfig.TTSMode getTTSMode() {
            return this.ttsMode;
        }

        @Override
        public void setTTSMode(IWailaConfig.TTSMode ttsMode) {
            this.ttsMode = ttsMode;
        }

        @Override
        public boolean shouldDisplayFluids() {
            return this.fluidMode != IWailaConfig.FluidMode.NONE;
        }

        @Override
        public IWailaConfig.FluidMode getDisplayFluids() {
            return this.fluidMode;
        }

        @Override
        public void setDisplayFluids(boolean displayFluids) {
            this.fluidMode = displayFluids ? IWailaConfig.FluidMode.ANY : IWailaConfig.FluidMode.NONE;
        }

        @Override
        public void setDisplayFluids(IWailaConfig.FluidMode displayFluids) {
            this.fluidMode = displayFluids;
        }

        @Override
        public float getReachDistance() {
            return this.reachDistance;
        }

        @Override
        public void setReachDistance(float reachDistance) {
            this.reachDistance = Mth.m_14036_((float)reachDistance, (float)0.0f, (float)20.0f);
        }

        @Override
        public boolean isDebug() {
            return this.debug;
        }

        @Override
        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        @Override
        public void setItemModNameTooltip(boolean itemModNameTooltip) {
            this.itemModNameTooltip = itemModNameTooltip;
        }

        @Override
        public boolean showItemModNameTooltip() {
            return this.itemModNameTooltip && itemModNameTooltipDisabledByMods.isEmpty();
        }

        @Override
        public IWailaConfig.BossBarOverlapMode getBossBarOverlapMode() {
            return this.bossBarOverlapMode;
        }

        @Override
        public void setBossBarOverlapMode(IWailaConfig.BossBarOverlapMode mode) {
            this.bossBarOverlapMode = mode;
        }

        @Override
        public void setHideFromTabList(boolean hideFromTabList) {
            this.hideFromTabList = hideFromTabList;
        }

        @Override
        public boolean shouldHideFromTabList() {
            return this.hideFromTabList;
        }

        @Override
        public boolean getDisplayBosses() {
            return this.displayBosses;
        }

        @Override
        public void setDisplayBosses(boolean displayBosses) {
            this.displayBosses = displayBosses;
        }
    }

    public static class ConfigOverlay
    implements IWailaConfig.IConfigOverlay {
        public ResourceLocation activeTheme;
        public int themesHash;
        private float overlayPosX;
        private float overlayPosY;
        private float overlayScale;
        private float overlayAnchorX;
        private float overlayAnchorY;
        private boolean overlaySquare;
        private boolean flipMainHand;
        @Expose
        private float autoScaleThreshold;
        private float alpha;
        private transient Theme activeThemeInstance;
        private IWailaConfig.IconMode iconMode;
        private boolean animation;
        private float disappearingDelay;

        public ConfigOverlay() {
            this.activeTheme = Theme.DARK.id;
            this.overlayPosX = 0.5f;
            this.overlayPosY = 1.0f;
            this.overlayScale = 1.0f;
            this.overlayAnchorX = 0.5f;
            this.overlayAnchorY = 0.0f;
            this.overlaySquare = false;
            this.flipMainHand = false;
            this.autoScaleThreshold = 0.4f;
            this.alpha = 0.7f;
            this.iconMode = IWailaConfig.IconMode.TOP;
            this.animation = true;
        }

        @Override
        public float getOverlayPosX() {
            return Mth.m_14036_((float)this.overlayPosX, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setOverlayPosX(float overlayPosX) {
            this.overlayPosX = Mth.m_14036_((float)overlayPosX, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getOverlayPosY() {
            return Mth.m_14036_((float)this.overlayPosY, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setOverlayPosY(float overlayPosY) {
            this.overlayPosY = Mth.m_14036_((float)overlayPosY, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getOverlayScale() {
            return this.overlayScale;
        }

        @Override
        public void setOverlayScale(float overlayScale) {
            this.overlayScale = Mth.m_14036_((float)overlayScale, (float)0.2f, (float)2.0f);
        }

        @Override
        public float getAnchorX() {
            return Mth.m_14036_((float)this.overlayAnchorX, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setAnchorX(float overlayAnchorX) {
            this.overlayAnchorX = Mth.m_14036_((float)overlayAnchorX, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getAnchorY() {
            return Mth.m_14036_((float)this.overlayAnchorY, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setAnchorY(float overlayAnchorY) {
            this.overlayAnchorY = Mth.m_14036_((float)overlayAnchorY, (float)0.0f, (float)1.0f);
        }

        @Override
        public boolean getFlipMainHand() {
            return this.flipMainHand;
        }

        @Override
        public void setFlipMainHand(boolean overlaySquare) {
            this.flipMainHand = overlaySquare;
        }

        @Override
        public float tryFlip(float f) {
            if (Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.LEFT) {
                f = 1.0f - f;
            }
            return f;
        }

        @Override
        public boolean getSquare() {
            return this.overlaySquare;
        }

        @Override
        public void setSquare(boolean overlaySquare) {
            this.overlaySquare = overlaySquare;
        }

        @Override
        public float getAutoScaleThreshold() {
            return this.autoScaleThreshold;
        }

        @Override
        public float getAlpha() {
            return this.alpha;
        }

        @Override
        public void setAlpha(float alpha) {
            this.alpha = Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f);
        }

        @Override
        public Theme getTheme() {
            if (this.activeThemeInstance == null) {
                this.applyTheme(this.activeTheme);
            }
            return this.activeThemeInstance;
        }

        @Override
        @Deprecated
        public Collection<Theme> getThemes() {
            return IThemeHelper.get().getThemes();
        }

        @Override
        public void applyTheme(ResourceLocation id) {
            this.activeThemeInstance = IThemeHelper.get().getTheme(id);
            this.activeTheme = this.activeThemeInstance.id;
            BoxStyle.DEFAULT.borderColor = this.activeThemeInstance.boxBorderColor;
        }

        @Override
        public IWailaConfig.IconMode getIconMode() {
            return this.iconMode;
        }

        @Override
        public void setIconMode(IWailaConfig.IconMode iconMode) {
            this.iconMode = iconMode;
        }

        @Override
        public boolean shouldShowIcon() {
            return this.iconMode != IWailaConfig.IconMode.HIDE;
        }

        @Override
        public boolean getAnimation() {
            return this.animation;
        }

        @Override
        public void setAnimation(boolean animation) {
            this.animation = animation;
        }

        @Override
        public void setDisappearingDelay(float delay) {
            this.disappearingDelay = delay;
        }

        @Override
        public float getDisappearingDelay() {
            return this.disappearingDelay;
        }
    }

    public static class ConfigFormatting
    implements IWailaConfig.IConfigFormatting {
        private String modName = "\u00a79\u00a7o%s";

        @Override
        public String getModName() {
            return this.modName;
        }

        @Override
        public void setModName(String modName) {
            this.modName = modName;
        }

        @Override
        @Deprecated
        public Component title(Object title) {
            return IThemeHelper.get().title(title);
        }

        @Override
        public Component registryName(String name) {
            return Component.m_237113_((String)name).m_130940_(IThemeHelper.get().isLightColorScheme() ? ChatFormatting.DARK_GRAY : ChatFormatting.GRAY);
        }
    }
}

