/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import net.pcal.fastback.shaded.org.eclipse.jgit.errors.NotSupportedException;
import net.pcal.fastback.shaded.org.eclipse.jgit.errors.TransportException;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.JGitText;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Repository;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.BundleFetchConnection;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.FetchConnection;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.PushConnection;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.Transport;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.TransportBundle;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.URIish;

public class TransportBundleStream
extends Transport
implements TransportBundle {
    private InputStream src;

    public TransportBundleStream(Repository db, URIish uri, InputStream in) {
        super(db, uri);
        this.src = in;
    }

    @Override
    public FetchConnection openFetch() throws TransportException {
        if (this.src == null) {
            throw new TransportException(this.uri, JGitText.get().onlyOneFetchSupported);
        }
        try {
            BundleFetchConnection bundleFetchConnection = new BundleFetchConnection(this, this.src);
            return bundleFetchConnection;
        }
        finally {
            this.src = null;
        }
    }

    @Override
    public PushConnection openPush() throws NotSupportedException {
        throw new NotSupportedException(JGitText.get().pushIsNotSupportedForBundleTransport);
    }

    @Override
    public void close() {
        if (this.src != null) {
            try {
                try {
                    this.src.close();
                }
                catch (IOException iOException) {
                    this.src = null;
                }
            }
            finally {
                this.src = null;
            }
        }
    }
}

