/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.notes;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.AbbreviatedObjectId;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.AnyObjectId;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.FileMode;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.MutableObjectId;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ObjectId;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ObjectInserter;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ObjectReader;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.TreeFormatter;
import net.pcal.fastback.shaded.org.eclipse.jgit.notes.InMemoryNoteBucket;
import net.pcal.fastback.shaded.org.eclipse.jgit.notes.LeafBucket;
import net.pcal.fastback.shaded.org.eclipse.jgit.notes.NonNoteEntry;
import net.pcal.fastback.shaded.org.eclipse.jgit.notes.Note;
import net.pcal.fastback.shaded.org.eclipse.jgit.notes.NoteBucket;
import net.pcal.fastback.shaded.org.eclipse.jgit.notes.NoteParser;

class FanoutBucket
extends InMemoryNoteBucket {
    private final NoteBucket[] table = new NoteBucket[256];
    private int cnt;
    private static final byte[] hexchar = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    FanoutBucket(int prefixLen) {
        super(prefixLen);
    }

    void setBucket(int cell, ObjectId id) {
        this.table[cell] = new LazyNoteBucket(id);
        ++this.cnt;
    }

    void setBucket(int cell, InMemoryNoteBucket bucket) {
        this.table[cell] = bucket;
        ++this.cnt;
    }

    @Override
    Note getNote(AnyObjectId objId, ObjectReader or) throws IOException {
        NoteBucket b = this.table[this.cell(objId)];
        return b != null ? b.getNote(objId, or) : null;
    }

    NoteBucket getBucket(int cell) {
        return this.table[cell];
    }

    static InMemoryNoteBucket loadIfLazy(NoteBucket b, AnyObjectId prefix, ObjectReader or) throws IOException {
        if (b == null) {
            return null;
        }
        if (b instanceof InMemoryNoteBucket) {
            return (InMemoryNoteBucket)b;
        }
        return ((LazyNoteBucket)b).load(prefix, or);
    }

    @Override
    Iterator<Note> iterator(AnyObjectId objId, final ObjectReader reader) throws IOException {
        final MutableObjectId id = new MutableObjectId();
        id.fromObjectId(objId);
        return new Iterator<Note>(){
            private int cell;
            private Iterator<Note> itr;

            /*
             * Unable to fully structure code
             */
            @Override
            public boolean hasNext() {
                if (this.itr == null || !this.itr.hasNext()) ** GOTO lbl15
                return true;
lbl-1000:
                // 1 sources

                {
                    b = FanoutBucket.this.table[this.cell];
                    if (b != null) {
                        try {
                            id.setByte(FanoutBucket.this.prefixLen >> 1, this.cell);
                            this.itr = b.iterator(id, reader);
                        }
                        catch (IOException err) {
                            throw new RuntimeException(err);
                        }
                        if (this.itr.hasNext()) {
                            ++this.cell;
                            return true;
                        }
                    }
                    ++this.cell;
lbl15:
                    // 2 sources

                    ** while (this.cell < FanoutBucket.this.table.length)
                }
lbl16:
                // 1 sources

                return false;
            }

            @Override
            public Note next() {
                if (this.hasNext()) {
                    return this.itr.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    int estimateSize(AnyObjectId noteOn, ObjectReader or) throws IOException {
        if (192 <= this.cnt) {
            return 257;
        }
        MutableObjectId id = new MutableObjectId();
        id.fromObjectId(noteOn);
        int sz = 0;
        int cell = 0;
        while (cell < 256) {
            NoteBucket b = this.table[cell];
            if (b != null) {
                id.setByte(this.prefixLen >> 1, cell);
                if (256 < (sz += b.estimateSize(id, or))) break;
            }
            ++cell;
        }
        return sz;
    }

    @Override
    InMemoryNoteBucket set(AnyObjectId noteOn, AnyObjectId noteData, ObjectReader or) throws IOException {
        int cell = this.cell(noteOn);
        NoteBucket b = this.table[cell];
        if (b == null) {
            if (noteData == null) {
                return this;
            }
            LeafBucket n = new LeafBucket(this.prefixLen + 2);
            this.table[cell] = n.set(noteOn, noteData, or);
            ++this.cnt;
            return this;
        }
        InMemoryNoteBucket n = b.set(noteOn, noteData, or);
        if (n == null) {
            this.table[cell] = null;
            --this.cnt;
            if (this.cnt == 0) {
                return null;
            }
            return this.contractIfTooSmall(noteOn, or);
        }
        if (n != b) {
            this.table[cell] = n;
        }
        return this;
    }

    InMemoryNoteBucket contractIfTooSmall(AnyObjectId noteOn, ObjectReader or) throws IOException {
        if (this.estimateSize(noteOn, or) < 256) {
            InMemoryNoteBucket r = new LeafBucket(this.prefixLen);
            Iterator<Note> i = this.iterator(noteOn, or);
            while (i.hasNext()) {
                r = ((InMemoryNoteBucket)r).append(i.next());
            }
            r.nonNotes = this.nonNotes;
            return r;
        }
        return this;
    }

    @Override
    ObjectId writeTree(ObjectInserter inserter) throws IOException {
        return inserter.insert(this.build(true, inserter));
    }

    @Override
    ObjectId getTreeId() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ObjectInserter.Formatter f = new ObjectInserter.Formatter();){
                return f.idFor(this.build(false, null));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private TreeFormatter build(boolean insert, ObjectInserter inserter) throws IOException {
        byte[] nameBuf = new byte[2];
        TreeFormatter fmt = new TreeFormatter(this.treeSize());
        NonNoteEntry e = this.nonNotes;
        int cell = 0;
        while (cell < 256) {
            NoteBucket b = this.table[cell];
            if (b != null) {
                nameBuf[0] = hexchar[cell >>> 4];
                nameBuf[1] = hexchar[cell & 0xF];
                while (e != null && e.pathCompare(nameBuf, 0, 2, FileMode.TREE) < 0) {
                    e.format(fmt);
                    e = e.next;
                }
                ObjectId id = insert ? b.writeTree(inserter) : b.getTreeId();
                fmt.append(nameBuf, 0, 2, FileMode.TREE, id);
            }
            ++cell;
        }
        while (e != null) {
            e.format(fmt);
            e = e.next;
        }
        return fmt;
    }

    private int treeSize() {
        int sz = this.cnt * TreeFormatter.entrySize(FileMode.TREE, 2);
        NonNoteEntry e = this.nonNotes;
        while (e != null) {
            sz += e.treeEntrySize();
            e = e.next;
        }
        return sz;
    }

    @Override
    InMemoryNoteBucket append(Note note) {
        int cell = this.cell(note);
        InMemoryNoteBucket b = (InMemoryNoteBucket)this.table[cell];
        if (b == null) {
            LeafBucket n = new LeafBucket(this.prefixLen + 2);
            this.table[cell] = n.append(note);
            ++this.cnt;
        } else {
            InMemoryNoteBucket n = b.append(note);
            if (n != b) {
                this.table[cell] = n;
            }
        }
        return this;
    }

    private int cell(AnyObjectId id) {
        return id.getByte(this.prefixLen >> 1);
    }

    private class LazyNoteBucket
    extends NoteBucket {
        private final ObjectId treeId;

        LazyNoteBucket(ObjectId treeId) {
            this.treeId = treeId;
        }

        @Override
        Note getNote(AnyObjectId objId, ObjectReader or) throws IOException {
            return this.load(objId, or).getNote(objId, or);
        }

        @Override
        Iterator<Note> iterator(AnyObjectId objId, ObjectReader reader) throws IOException {
            return this.load(objId, reader).iterator(objId, reader);
        }

        @Override
        int estimateSize(AnyObjectId objId, ObjectReader or) throws IOException {
            return this.load(objId, or).estimateSize(objId, or);
        }

        @Override
        InMemoryNoteBucket set(AnyObjectId noteOn, AnyObjectId noteData, ObjectReader or) throws IOException {
            return this.load(noteOn, or).set(noteOn, noteData, or);
        }

        @Override
        ObjectId writeTree(ObjectInserter inserter) {
            return this.treeId;
        }

        @Override
        ObjectId getTreeId() {
            return this.treeId;
        }

        private InMemoryNoteBucket load(AnyObjectId prefix, ObjectReader or) throws IOException {
            AbbreviatedObjectId p = prefix.abbreviate(FanoutBucket.this.prefixLen + 2);
            InMemoryNoteBucket self = NoteParser.parse(p, this.treeId, or);
            FanoutBucket.this.table[FanoutBucket.this.cell((AnyObjectId)prefix)] = self;
            return self;
        }
    }
}

