/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.JGitText;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool.CommandExecutor;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool.CommandLineMergeTool;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool.ExternalMergeTool;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool.ExternalToolUtils;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool.FileElement;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool.InformNoToolHandler;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool.MergeToolConfig;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool.PreDefinedMergeTool;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool.PromptContinueHandler;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool.ToolException;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Repository;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.StoredConfig;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.internal.BooleanTriState;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.FS;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.StringUtils;

public class MergeTools {
    private final FS fs;
    private final File gitDir;
    private final File workTree;
    private final MergeToolConfig config;
    private final Repository repo;
    private final Map<String, ExternalMergeTool> predefinedTools;
    private final Map<String, ExternalMergeTool> userDefinedTools;

    public MergeTools(Repository repo) {
        this(repo, repo.getConfig());
    }

    public MergeTools(StoredConfig config) {
        this(null, config);
    }

    private MergeTools(Repository repo, StoredConfig config) {
        this.repo = repo;
        this.config = config.get(MergeToolConfig.KEY);
        this.gitDir = repo == null ? null : repo.getDirectory();
        this.fs = repo == null ? FS.DETECTED : repo.getFS();
        this.workTree = repo == null ? null : repo.getWorkTree();
        this.predefinedTools = this.setupPredefinedTools();
        this.userDefinedTools = this.setupUserDefinedTools(this.predefinedTools);
    }

    public Optional<FS.ExecutionResult> merge(FileElement localFile, FileElement remoteFile, FileElement mergedFile, FileElement baseFile, File tempDir, Optional<String> toolName, BooleanTriState prompt, boolean gui, PromptContinueHandler promptHandler, InformNoToolHandler noToolHandler) throws ToolException {
        String toolNameToUse;
        if (toolName == null) {
            throw new ToolException(JGitText.get().diffToolNullError);
        }
        if (toolName.isPresent()) {
            toolNameToUse = toolName.get();
        } else {
            toolNameToUse = this.getDefaultToolName(gui);
            if (StringUtils.isEmptyOrNull(toolNameToUse)) {
                noToolHandler.inform(new ArrayList<String>(this.predefinedTools.keySet()));
                toolNameToUse = this.getFirstAvailableTool();
            }
        }
        if (StringUtils.isEmptyOrNull(toolNameToUse)) {
            throw new ToolException(JGitText.get().diffToolNotGivenError);
        }
        boolean doPrompt = prompt != BooleanTriState.UNSET ? prompt == BooleanTriState.TRUE : this.isInteractive();
        if (doPrompt && !promptHandler.prompt(toolNameToUse)) {
            return Optional.empty();
        }
        ExternalMergeTool tool = this.getTool(toolNameToUse);
        if (tool == null) {
            throw new ToolException("External merge tool is not defined: " + toolNameToUse);
        }
        return Optional.of(this.merge(localFile, remoteFile, mergedFile, baseFile, tempDir, tool));
    }

    public FS.ExecutionResult merge(FileElement localFile, FileElement remoteFile, FileElement mergedFile, FileElement baseFile, File tempDir, ExternalMergeTool tool) throws ToolException {
        FileElement backup = null;
        FS.ExecutionResult result = null;
        try {
            backup = this.createBackupFile(mergedFile, tempDir != null ? tempDir : this.workTree);
            String command = ExternalToolUtils.prepareCommand(tool.getCommand(baseFile != null), localFile, remoteFile, mergedFile, baseFile);
            Map<String, String> env = ExternalToolUtils.prepareEnvironment(this.gitDir, localFile, remoteFile, mergedFile, baseFile);
            boolean trust = tool.getTrustExitCode() == BooleanTriState.TRUE;
            CommandExecutor cmdExec = new CommandExecutor(this.fs, trust);
            result = cmdExec.run(command, this.workTree, env);
            if (backup != null) {
                this.keepBackupFile(mergedFile.getPath(), backup);
            }
            FS.ExecutionResult executionResult = result;
            return executionResult;
        }
        catch (IOException | InterruptedException e) {
            throw new ToolException(e);
        }
        finally {
            if (backup != null) {
                backup.cleanTemporaries();
            }
            if (result != null || !this.config.isKeepTemporaries()) {
                localFile.cleanTemporaries();
                remoteFile.cleanTemporaries();
                if (baseFile != null) {
                    baseFile.cleanTemporaries();
                }
                if (this.config.isWriteToTemp() && tempDir != null && tempDir.exists()) {
                    tempDir.delete();
                }
            }
        }
    }

    private FileElement createBackupFile(FileElement from, File toParentDir) throws IOException {
        FileElement backup = null;
        Path path = Paths.get(from.getPath(), new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            backup = new FileElement(from.getPath(), FileElement.Type.BACKUP);
            Files.copy(path, backup.createTempFile(toParentDir).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return backup;
    }

    public File createTempDirectory() throws IOException {
        return this.config.isWriteToTemp() ? Files.createTempDirectory("jgit-mergetool-", new FileAttribute[0]).toFile() : null;
    }

    public Set<String> getUserDefinedToolNames() {
        return this.userDefinedTools.keySet();
    }

    public Set<String> getPredefinedToolNames() {
        return this.predefinedTools.keySet();
    }

    public Set<String> getAllToolNames() {
        String defaultName = this.getDefaultToolName(false);
        if (defaultName == null) {
            defaultName = this.getFirstAvailableTool();
        }
        return ExternalToolUtils.createSortedToolSet(defaultName, this.getUserDefinedToolNames(), this.getPredefinedToolNames());
    }

    public Optional<String> getExternalToolFromAttributes(String path) throws ToolException {
        return ExternalToolUtils.getExternalToolFromAttributes(this.repo, path, "mergetool");
    }

    public Set<String> getPredefinedAvailableTools() {
        Map<String, ExternalMergeTool> defTools = this.getPredefinedTools(true);
        LinkedHashSet<String> availableTools = new LinkedHashSet<String>();
        for (Map.Entry<String, ExternalMergeTool> elem : defTools.entrySet()) {
            if (!elem.getValue().isAvailable()) continue;
            availableTools.add(elem.getKey());
        }
        return availableTools;
    }

    public Map<String, ExternalMergeTool> getUserDefinedTools() {
        return Collections.unmodifiableMap(this.userDefinedTools);
    }

    public Map<String, ExternalMergeTool> getPredefinedTools(boolean checkAvailability) {
        if (checkAvailability) {
            for (ExternalMergeTool tool : this.predefinedTools.values()) {
                PreDefinedMergeTool predefTool = (PreDefinedMergeTool)tool;
                predefTool.setAvailable(ExternalToolUtils.isToolAvailable(this.fs, this.gitDir, this.workTree, predefTool.getPath()));
            }
        }
        return Collections.unmodifiableMap(this.predefinedTools);
    }

    public String getFirstAvailableTool() {
        String name = null;
        for (ExternalMergeTool tool : this.predefinedTools.values()) {
            if (!ExternalToolUtils.isToolAvailable(this.fs, this.gitDir, this.workTree, tool.getPath())) continue;
            name = tool.getName();
            break;
        }
        return name;
    }

    public boolean isInteractive() {
        return this.config.isPrompt();
    }

    public String getDefaultToolName(boolean gui) {
        return gui ? this.config.getDefaultGuiToolName() : this.config.getDefaultToolName();
    }

    private ExternalMergeTool getTool(String name) {
        ExternalMergeTool tool = this.userDefinedTools.get(name);
        if (tool == null) {
            tool = this.predefinedTools.get(name);
        }
        return tool;
    }

    private void keepBackupFile(String mergedFilePath, FileElement backup) throws IOException {
        if (this.config.isKeepBackup()) {
            Path backupPath = backup.getFile().toPath();
            Files.move(backupPath, backupPath.resolveSibling(Paths.get(mergedFilePath, new String[0]).getFileName() + ".orig"), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private Map<String, ExternalMergeTool> setupPredefinedTools() {
        TreeMap<String, ExternalMergeTool> tools = new TreeMap<String, ExternalMergeTool>();
        CommandLineMergeTool[] commandLineMergeToolArray = CommandLineMergeTool.values();
        int n = commandLineMergeToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            CommandLineMergeTool tool = commandLineMergeToolArray[n2];
            tools.put(tool.name(), new PreDefinedMergeTool(tool));
            ++n2;
        }
        return tools;
    }

    private Map<String, ExternalMergeTool> setupUserDefinedTools(Map<String, ExternalMergeTool> predefTools) {
        TreeMap<String, ExternalMergeTool> tools = new TreeMap<String, ExternalMergeTool>();
        Map<String, ExternalMergeTool> userTools = this.config.getTools();
        for (String name : userTools.keySet()) {
            PreDefinedMergeTool predefTool;
            ExternalMergeTool userTool = userTools.get(name);
            if (userTool.getCommand() != null) {
                tools.put(name, userTool);
                continue;
            }
            if (userTool.getPath() == null || (predefTool = (PreDefinedMergeTool)predefTools.get(name)) == null) continue;
            predefTool.setPath(userTool.getPath());
            if (userTool.getTrustExitCode() == BooleanTriState.UNSET) continue;
            predefTool.setTrustExitCode(userTool.getTrustExitCode());
        }
        return tools;
    }
}

