/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.errors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.JGitText;

public class CompoundException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final List<Throwable> causeList;

    private static String format(Collection<Throwable> causes) {
        StringBuilder msg = new StringBuilder();
        msg.append(JGitText.get().failureDueToOneOfTheFollowing);
        for (Throwable c : causes) {
            msg.append("  ");
            msg.append(c.getMessage());
            msg.append("\n");
        }
        return msg.toString();
    }

    public CompoundException(Collection<Throwable> why) {
        super(CompoundException.format(why));
        this.causeList = Collections.unmodifiableList(new ArrayList<Throwable>(why));
    }

    public List<Throwable> getAllCauses() {
        return this.causeList;
    }
}

