/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.attributes;

public final class Attribute {
    private final String key;
    private final State state;
    private final String value;

    public Attribute(String key, State state) {
        this(key, state, null);
    }

    private Attribute(String key, State state, String value) {
        if (key == null) {
            throw new NullPointerException("The key of an attribute should not be null");
        }
        if (state == null) {
            throw new NullPointerException("The state of an attribute should not be null");
        }
        this.key = key;
        this.state = state;
        this.value = value;
    }

    public Attribute(String key, String value) {
        this(key, State.CUSTOM, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)obj;
        if (!this.key.equals(other.key)) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String getKey() {
        return this.key;
    }

    public State getState() {
        return this.state;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.state.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public String toString() {
        switch (this.state) {
            case SET: {
                return this.key;
            }
            case UNSET: {
                return "-" + this.key;
            }
            case UNSPECIFIED: {
                return "!" + this.key;
            }
        }
        return String.valueOf(this.key) + "=" + this.value;
    }

    public static enum State {
        SET,
        UNSET,
        UNSPECIFIED,
        CUSTOM;

    }
}

