/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.repo;

import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ProgressMonitor;

abstract class JGitPercentageProgressMonitor
implements ProgressMonitor {
    private String currentTask;
    private int currentTotalWork;
    private int totalCompleted;

    protected JGitPercentageProgressMonitor() {
    }

    @Override
    public final void start(int totalTasks) {
    }

    @Override
    public final void beginTask(String taskName, int totalWork) {
        this.currentTask = taskName;
        this.currentTotalWork = totalWork;
        this.totalCompleted = 0;
        this.progressStart(this.currentTask);
    }

    @Override
    public final void update(int completed) {
        this.totalCompleted += completed;
        int percent = this.currentTotalWork == 0 ? 0 : this.totalCompleted * 100 / this.currentTotalWork;
        this.progressUpdate(this.currentTask, percent);
    }

    @Override
    public final void endTask() {
        this.progressDone(this.currentTask);
        this.currentTask = null;
    }

    @Override
    public final boolean isCancelled() {
        return false;
    }

    protected abstract void progressStart(String var1);

    protected abstract void progressUpdate(String var1, int var2);

    protected abstract void progressDone(String var1);
}

