/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.api.math;

import com.mojang.blaze3d.vertex.PoseStack;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MatrixHelper {
    public static int transformNormal(Matrix3f mat, float x, float y, float z) {
        float nxt = MatrixHelper.transformNormalX(mat, x, y, z);
        float nyt = MatrixHelper.transformNormalY(mat, x, y, z);
        float nzt = MatrixHelper.transformNormalZ(mat, x, y, z);
        return NormI8.pack(nxt, nyt, nzt);
    }

    public static int transformNormal(Matrix3f mat, int norm) {
        float x = NormI8.unpackX(norm);
        float y = NormI8.unpackY(norm);
        float z = NormI8.unpackZ(norm);
        return MatrixHelper.transformNormal(mat, x, y, z);
    }

    public static float transformNormalX(Matrix3f mat, float x, float y, float z) {
        return mat.m00() * x + mat.m10() * y + mat.m20() * z;
    }

    public static float transformNormalY(Matrix3f mat, float x, float y, float z) {
        return mat.m01() * x + mat.m11() * y + mat.m21() * z;
    }

    public static float transformNormalZ(Matrix3f mat, float x, float y, float z) {
        return mat.m02() * x + mat.m12() * y + mat.m22() * z;
    }

    public static float transformPositionX(Matrix4f mat, float x, float y, float z) {
        return mat.m00() * x + mat.m10() * y + mat.m20() * z + mat.m30();
    }

    public static float transformPositionY(Matrix4f mat, float x, float y, float z) {
        return mat.m01() * x + mat.m11() * y + mat.m21() * z + mat.m31();
    }

    public static float transformPositionZ(Matrix4f mat, float x, float y, float z) {
        return mat.m02() * x + mat.m12() * y + mat.m22() * z + mat.m32();
    }

    public static void rotateZYX(PoseStack.Pose matrices, float angleZ, float angleY, float angleX) {
        float sinX = Math.sin((float)angleX);
        float cosX = Math.cosFromSin((float)sinX, (float)angleX);
        float sinInvX = -sinX;
        float sinY = Math.sin((float)angleY);
        float cosY = Math.cosFromSin((float)sinY, (float)angleY);
        float sinInvY = -sinY;
        float sinZ = Math.sin((float)angleZ);
        float cosZ = Math.cosFromSin((float)sinZ, (float)angleZ);
        float sinInvZ = -sinZ;
        MatrixHelper.applySinCosMat4(matrices.m_252922_(), sinX, sinY, sinZ, cosX, cosY, cosZ, sinInvX, sinInvY, sinInvZ);
        MatrixHelper.applySinCosMat3(matrices.m_252943_(), sinX, sinY, sinZ, cosX, cosY, cosZ, sinInvX, sinInvY, sinInvZ);
    }

    private static void applySinCosMat4(Matrix4f mat, float sinX, float sinY, float sinZ, float cosX, float cosY, float cosZ, float sinInvX, float sinInvY, float sinInvZ) {
        float nm00 = mat.m00() * cosZ + mat.m10() * sinZ;
        float nm01 = mat.m01() * cosZ + mat.m11() * sinZ;
        float nm02 = mat.m02() * cosZ + mat.m12() * sinZ;
        float nm03 = mat.m03() * cosZ + mat.m13() * sinZ;
        float nm10 = mat.m00() * sinInvZ + mat.m10() * cosZ;
        float nm11 = mat.m01() * sinInvZ + mat.m11() * cosZ;
        float nm12 = mat.m02() * sinInvZ + mat.m12() * cosZ;
        float nm13 = mat.m03() * sinInvZ + mat.m13() * cosZ;
        float nm20 = nm00 * sinY + mat.m20() * cosY;
        float nm21 = nm01 * sinY + mat.m21() * cosY;
        float nm22 = nm02 * sinY + mat.m22() * cosY;
        float nm23 = nm03 * sinY + mat.m23() * cosY;
        mat.set(nm00 * cosY + mat.m20() * sinInvY, nm01 * cosY + mat.m21() * sinInvY, nm02 * cosY + mat.m22() * sinInvY, nm03 * cosY + mat.m23() * sinInvY, nm10 * cosX + nm20 * sinX, nm11 * cosX + nm21 * sinX, nm12 * cosX + nm22 * sinX, nm13 * cosX + nm23 * sinX, nm10 * sinInvX + nm20 * cosX, nm11 * sinInvX + nm21 * cosX, nm12 * sinInvX + nm22 * cosX, nm13 * sinInvX + nm23 * cosX, mat.m30(), mat.m31(), mat.m32(), mat.m33());
    }

    private static void applySinCosMat3(Matrix3f mat, float sinX, float sinY, float sinZ, float cosX, float cosY, float cosZ, float sinInvX, float sinInvY, float sinInvZ) {
        float nm00 = mat.m00() * cosZ + mat.m10() * sinZ;
        float nm01 = mat.m01() * cosZ + mat.m11() * sinZ;
        float nm02 = mat.m02() * cosZ + mat.m12() * sinZ;
        float nm10 = mat.m00() * sinInvZ + mat.m10() * cosZ;
        float nm11 = mat.m01() * sinInvZ + mat.m11() * cosZ;
        float nm12 = mat.m02() * sinInvZ + mat.m12() * cosZ;
        float nm20 = nm00 * sinY + mat.m20() * cosY;
        float nm21 = nm01 * sinY + mat.m21() * cosY;
        float nm22 = nm02 * sinY + mat.m22() * cosY;
        mat.set(nm00 * cosY + mat.m20() * sinInvY, nm01 * cosY + mat.m21() * sinInvY, nm02 * cosY + mat.m22() * sinInvY, nm10 * cosX + nm20 * sinX, nm11 * cosX + nm21 * sinX, nm12 * cosX + nm22 * sinX, nm10 * sinInvX + nm20 * cosX, nm11 * sinInvX + nm21 * cosX, nm12 * sinInvX + nm22 * cosX);
    }
}

