/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.type.collapsed;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CollapsibleEntryRegistryImpl
implements CollapsibleEntryRegistry {
    private final Map<ResourceLocation, Entry> entries = new LinkedHashMap<ResourceLocation, Entry>();

    @Override
    public <T> void group(ResourceLocation id, Component name, List<? extends EntryStack<? extends T>> stacks) {
        Objects.requireNonNull(stacks, "stacks");
        Entry old = this.entries.put(id, new Entry(id, name, new ListMatcher(CollectionUtils.map(stacks, HashedEntryStackWrapper::new)), true));
        InternalLogger.getInstance().debug("Added collapsible entry group [%s] %s with %d entries", id, name.getString(), stacks.size());
        if (old != null) {
            InternalLogger.getInstance().warn("Overwritten collapsible entry group [%s] %s with %d entries", id, name.getString(), stacks.size());
        }
    }

    @Override
    public void group(ResourceLocation id, Component name, Predicate<? extends EntryStack<?>> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        Entry old = this.entries.put(id, new Entry(id, name, (stack, hashExact) -> predicate.test(stack), false));
        InternalLogger.getInstance().debug("Added collapsible entry group [%s] %s with dynamic predicate", id, name.getString());
        if (old != null) {
            InternalLogger.getInstance().warn("Overwritten collapsible entry group [%s] %s with dynamic predicate", id, name.getString());
        }
    }

    @Override
    public void startReload() {
        this.entries.clear();
    }

    @Override
    public void endReload() {
        InternalLogger.getInstance().debug("Registered %d collapsible entry groups: %s", this.entries.values().size(), this.entries.values().stream().map(entry -> entry.getName().getString()).collect(Collectors.joining(", ")));
    }

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerCollapsibleEntries(this);
    }

    public Collection<Entry> getEntries() {
        return this.entries.values();
    }

    public static class Entry {
        private final ResourceLocation id;
        private final Component name;
        private final Matcher matcher;
        private boolean canCache;
        private boolean expanded;

        public Entry(ResourceLocation id, Component name, Matcher matcher, boolean canCache) {
            this.id = id;
            this.name = name;
            this.matcher = matcher;
            this.canCache = canCache;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public String getModId() {
            return this.id.m_135827_();
        }

        public Component getName() {
            return this.name;
        }

        public Matcher getMatcher() {
            return this.matcher;
        }

        public boolean canCache() {
            return this.canCache;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public void setExpanded(boolean expanded) {
            this.expanded = expanded;
        }
    }

    private static class ListMatcher
    implements Matcher {
        private final Set<HashedEntryStackWrapper> stacks;

        public ListMatcher(List<? extends HashedEntryStackWrapper> stacks) {
            this.stacks = new HashSet<HashedEntryStackWrapper>(stacks);
        }

        @Override
        public boolean matches(EntryStack<?> stack, long hashExact) {
            return this.stacks.contains(new HashedEntryStackWrapper(stack, hashExact));
        }
    }

    @FunctionalInterface
    public static interface Matcher {
        public boolean matches(EntryStack<?> var1, long var2);
    }
}

