/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.type;

import it.unimi.dsi.fastutil.longs.LongList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryList;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.core.registries.BuiltInRegistries;

public class EntryRegistryListImpl
implements EntryRegistryList {
    private final List<HashedEntryStackWrapper> hashedList = new ArrayList<HashedEntryStackWrapper>(BuiltInRegistries.f_257033_.m_6566_().size() + 100);
    private final List<EntryStack<?>> list = EntryRegistryListImpl.createMappedList(this.hashedList);

    public EntryRegistryListImpl() {
    }

    public EntryRegistryListImpl(Stream<EntryStack<?>> list) {
        list.collect(Collectors.toCollection(() -> this.list));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Stream<EntryStack<?>> stream() {
        return this.list.stream();
    }

    @Override
    public List<EntryStack<?>> collect() {
        return this.list;
    }

    @Override
    public List<HashedEntryStackWrapper> collectHashed() {
        return this.hashedList;
    }

    @Override
    public int indexOf(EntryStack<?> stack) {
        return this.list.indexOf(stack);
    }

    @Override
    public int lastIndexOf(EntryStack<?> stack) {
        return this.list.lastIndexOf(stack);
    }

    @Override
    public void add(EntryStack<?> stack, long hashExact) {
        this.hashedList.add(new HashedEntryStackWrapper(stack, hashExact));
    }

    @Override
    public void add(int index, EntryStack<?> stack, long hashExact) {
        this.hashedList.add(index, new HashedEntryStackWrapper(stack, hashExact));
    }

    @Override
    public void addAll(final List<EntryStack<?>> stacks, final LongList hashes) {
        this.hashedList.addAll((Collection<HashedEntryStackWrapper>)new AbstractList<HashedEntryStackWrapper>(){

            @Override
            public HashedEntryStackWrapper get(int index) {
                return new HashedEntryStackWrapper((EntryStack)stacks.get(index), hashes.getLong(index));
            }

            @Override
            public int size() {
                return stacks.size();
            }
        });
    }

    @Override
    public void addAll(int index, final List<EntryStack<?>> stacks, final LongList hashes) {
        this.hashedList.addAll(index, (Collection<HashedEntryStackWrapper>)new AbstractList<HashedEntryStackWrapper>(){

            @Override
            public HashedEntryStackWrapper get(int index) {
                return new HashedEntryStackWrapper((EntryStack)stacks.get(index), hashes.getLong(index));
            }

            @Override
            public int size() {
                return stacks.size();
            }
        });
    }

    @Override
    public void remove(EntryStack<?> stack, long hashExact) {
        this.hashedList.remove(new HashedEntryStackWrapper(stack, hashExact));
    }

    @Override
    public boolean removeExactIf(EntryRegistryList.StackFilteringPredicate predicate) {
        return this.hashedList.removeIf(stack -> predicate.test(stack.unwrap(), stack.hashExact()));
    }

    @Override
    public boolean needsHash() {
        return true;
    }

    public List<EntryStack<?>> getList() {
        return this.list;
    }

    private static List<EntryStack<?>> createMappedList(final List<HashedEntryStackWrapper> hashedList) {
        return new AbstractList<EntryStack<?>>(){

            @Override
            public EntryStack<?> get(int index) {
                return ((HashedEntryStackWrapper)hashedList.get(index)).unwrap();
            }

            @Override
            public int size() {
                return hashedList.size();
            }

            @Override
            public void add(int index, EntryStack<?> element) {
                hashedList.add(index, new HashedEntryStackWrapper(element));
            }

            @Override
            public EntryStack<?> set(int index, EntryStack<?> element) {
                return hashedList.set(index, new HashedEntryStackWrapper(element)).unwrap();
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof EntryStack) {
                    return hashedList.remove(new HashedEntryStackWrapper((EntryStack)o));
                }
                return false;
            }

            @Override
            public EntryStack<?> remove(int index) {
                return ((HashedEntryStackWrapper)hashedList.remove(index)).unwrap();
            }

            @Override
            public void clear() {
                hashedList.clear();
            }

            @Override
            public int indexOf(Object o) {
                if (o instanceof EntryStack) {
                    EntryStack stack = (EntryStack)o;
                    return hashedList.indexOf(new HashedEntryStackWrapper(stack));
                }
                return -1;
            }

            @Override
            public int lastIndexOf(Object o) {
                if (o instanceof EntryStack) {
                    EntryStack stack = (EntryStack)o;
                    return hashedList.lastIndexOf(new HashedEntryStackWrapper(stack));
                }
                return -1;
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof EntryStack) {
                    EntryStack stack = (EntryStack)o;
                    return hashedList.contains(new HashedEntryStackWrapper(stack));
                }
                return false;
            }
        };
    }
}

