/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.impl.client.gui.toast.ExportRecipeIdentifierToast;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

@ApiStatus.Internal
public final class RecipeDisplayExporter {
    private RecipeDisplayExporter() {
    }

    public static void exportRecipeDisplay(Rectangle rectangle, DisplaySpec display, List<Widget> widgets, boolean toast) {
        RecipeDisplayExporter.exportRecipe(rectangle, display, widgets);
        if (toast) {
            ExportRecipeIdentifierToast.addToast(I18n.m_118938_((String)"msg.rei.exported_recipe", (Object[])new Object[0]), I18n.m_118938_((String)"msg.rei.exported_recipe.desc", (Object[])new Object[0]));
        }
    }

    private static File getExportFilename(DisplaySpec display, File directory) {
        Collection<ResourceLocation> locations = display.provideInternalDisplayIds();
        String string = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
        if (!locations.isEmpty()) {
            string = locations.iterator().next().toString().replace('/', '_').replace(':', '_');
        }
        int i = 1;
        File file;
        while ((file = new File(directory, string + (String)(i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file;
    }

    private static void exportRecipe(Rectangle rectangle, DisplaySpec display, List<Widget> widgets) {
        Minecraft client = Minecraft.m_91087_();
        Window window = client.m_91268_();
        TextureTarget renderTarget = new TextureTarget(window.m_85441_(), window.m_85442_(), true, false);
        renderTarget.m_83947_(true);
        RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)((double)window.m_85441_() / window.m_85449_()), 0.0f, (float)((double)window.m_85442_() / window.m_85449_()), 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.f_276633_);
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.m_85836_();
        poseStack.m_166856_();
        poseStack.m_85837_(0.0, 0.0, -2000.0);
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
        GuiGraphics graphics = new GuiGraphics(client, client.m_91269_().m_110104_());
        for (Widget widget : widgets) {
            widget.m_88315_(graphics, -1, -1, 0.0f);
        }
        NativeImage nativeImage = new NativeImage(renderTarget.f_83915_, renderTarget.f_83916_, false);
        RenderSystem.bindTexture((int)renderTarget.m_83975_());
        nativeImage.m_85045_(0, false);
        nativeImage.m_85122_();
        int outWidth = (int)((double)rectangle.width * window.m_85449_());
        int outHeight = (int)((double)rectangle.height * window.m_85449_());
        NativeImage strippedImage = new NativeImage(outWidth, outHeight, false);
        for (int y = 0; y < outHeight; ++y) {
            for (int x = 0; x < outWidth; ++x) {
                strippedImage.m_84988_(x, y, nativeImage.m_84985_(x + (int)((double)rectangle.x * window.m_85449_()), y + (int)((double)rectangle.y * window.m_85449_())));
            }
        }
        Util.m_183992_().execute(() -> {
            try {
                File export = new File(Minecraft.m_91087_().f_91069_, "rei_exports/" + display.provideInternalDisplay().getCategoryIdentifier().toString().replace('/', '_').replace(':', '_'));
                export.mkdirs();
                strippedImage.m_85056_(RecipeDisplayExporter.getExportFilename(display, export));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                nativeImage.close();
                strippedImage.close();
            }
        });
        renderTarget.m_83930_();
        Minecraft.m_91087_().f_91060_.m_173014_();
        Minecraft.m_91087_().m_91385_().m_83947_(true);
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }
}

