/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.reload;

import dev.shadowsoffire.placebo.json.PSerializer;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.reload.TypeKeyed;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;

public interface RegistryCallback<R extends TypeKeyed & PSerializer.PSerializable<? super R>> {
    public void beginReload(DynamicRegistry<R> var1);

    public void onReload(DynamicRegistry<R> var1);

    public static <R extends TypeKeyed & PSerializer.PSerializable<? super R>> RegistryCallback<R> create(Consumer<DynamicRegistry<R>> beginReload, Consumer<DynamicRegistry<R>> onReload) {
        return new Delegated<R>(beginReload, onReload);
    }

    public static <R extends TypeKeyed & PSerializer.PSerializable<? super R>> RegistryCallback<R> beginOnly(Consumer<DynamicRegistry<R>> beginReload) {
        return new Delegated<R>(beginReload, v -> {});
    }

    public static <R extends TypeKeyed & PSerializer.PSerializable<? super R>> RegistryCallback<R> reloadOnly(Consumer<DynamicRegistry<R>> onReload) {
        return new Delegated(v -> {}, onReload);
    }

    @ApiStatus.Internal
    public static class Delegated<R extends TypeKeyed & PSerializer.PSerializable<? super R>>
    implements RegistryCallback<R> {
        private Consumer<DynamicRegistry<R>> beginReload;
        private Consumer<DynamicRegistry<R>> onReload;

        public Delegated(Consumer<DynamicRegistry<R>> beginReload, Consumer<DynamicRegistry<R>> onReload) {
            this.beginReload = beginReload;
            this.onReload = onReload;
        }

        @Override
        public void beginReload(DynamicRegistry<R> manager) {
            this.beginReload.accept(manager);
        }

        @Override
        public void onReload(DynamicRegistry<R> manager) {
            this.onReload.accept(manager);
        }
    }
}

