/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.reload;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.json.JsonUtil;
import dev.shadowsoffire.placebo.json.PSerializer;
import dev.shadowsoffire.placebo.json.SerializerMap;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.RegistryCallback;
import dev.shadowsoffire.placebo.reload.ReloadListenerPacket;
import dev.shadowsoffire.placebo.reload.TypeKeyed;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public abstract class DynamicRegistry<R extends TypeKeyed & PSerializer.PSerializable<? super R>>
extends SimpleJsonResourceReloadListener {
    public static final ResourceLocation DEFAULT = new ResourceLocation("default");
    protected final Logger logger;
    protected final String path;
    protected final boolean synced;
    protected final boolean subtypes;
    protected final SerializerMap<R> serializers;
    protected final Codec<DynamicHolder<R>> holderCodec;
    protected Map<ResourceLocation, R> registry = ImmutableMap.of();
    private final Map<ResourceLocation, R> staged = new HashMap<ResourceLocation, R>();
    private final Map<ResourceLocation, DynamicHolder<? extends R>> holders = new ConcurrentHashMap<ResourceLocation, DynamicHolder<? extends R>>();
    private final Set<RegistryCallback<R>> callbacks = new HashSet<RegistryCallback<R>>();
    private WeakReference<ICondition.IContext> context;

    public DynamicRegistry(Logger logger, String path, boolean synced, boolean subtypes) {
        super(new GsonBuilder().setLenient().create(), path);
        this.logger = logger;
        this.path = path;
        this.synced = synced;
        this.subtypes = subtypes;
        this.serializers = new SerializerMap(path);
        this.registerBuiltinSerializers();
        if (this.serializers.isEmpty()) {
            throw new RuntimeException("Attempted to create a json reload listener for " + path + " with no built-in serializers!");
        }
        this.holderCodec = ResourceLocation.f_135803_.xmap(this::holder, DynamicHolder::getId);
    }

    protected final void apply(Map<ResourceLocation, JsonElement> objects, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.beginReload();
        objects.forEach((key, ele) -> {
            try {
                if (JsonUtil.checkAndLogEmpty(ele, key, this.path, this.logger) && JsonUtil.checkConditions(ele, key, this.path, this.logger, this.getContext())) {
                    JsonObject obj = ele.getAsJsonObject();
                    TypeKeyed deserialized = this.subtypes ? (TypeKeyed)this.serializers.read(obj) : (TypeKeyed)this.serializers.get(DEFAULT).read(obj);
                    deserialized.setId((ResourceLocation)key);
                    Preconditions.checkNotNull((Object)deserialized.getId(), (Object)("A " + this.path + " with id " + key + " failed to set ID."));
                    Preconditions.checkNotNull(((PSerializer.PSerializable)((Object)deserialized)).getSerializer(), (Object)("A " + this.path + " with id " + key + " is not declaring a serializer."));
                    Preconditions.checkNotNull((Object)this.serializers.get(((PSerializer.PSerializable)((Object)deserialized)).getSerializer()), (Object)("A " + this.path + " with id " + key + " is declaring an unregistered serializer."));
                    this.register((ResourceLocation)key, (R)deserialized);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed parsing {} file {}.", (Object)this.path, key);
                this.logger.error("Underlying Exception: ", (Throwable)e);
            }
        });
        this.onReload();
    }

    protected abstract void registerBuiltinSerializers();

    protected void beginReload() {
        this.callbacks.forEach(l -> l.beginReload(this));
        this.registry = new HashMap<ResourceLocation, R>();
        this.holders.values().forEach(DynamicHolder::unbind);
    }

    protected void onReload() {
        this.registry = ImmutableMap.copyOf(this.registry);
        this.logger.info("Registered {} {}.", (Object)this.registry.size(), (Object)this.path);
        this.callbacks.forEach(l -> l.onReload(this));
        this.holders.values().forEach(DynamicHolder::bind);
    }

    public Set<ResourceLocation> getKeys() {
        return this.registry.keySet();
    }

    public Collection<R> getValues() {
        return this.registry.values();
    }

    @Nullable
    public R getValue(ResourceLocation key) {
        return this.getOrDefault(key, null);
    }

    public R getOrDefault(ResourceLocation key, R defValue) {
        return (R)((TypeKeyed)this.registry.getOrDefault(key, defValue));
    }

    public void registerToBus() {
        if (this.synced) {
            SyncManagement.registerForSync(this);
        }
        MinecraftForge.EVENT_BUS.addListener(this::addReloader);
    }

    public <T extends R> DynamicHolder<T> holder(ResourceLocation id) {
        return this.holders.computeIfAbsent(id, k -> new DynamicHolder(this, (ResourceLocation)k));
    }

    public <T extends R> DynamicHolder<T> holder(T t) {
        return this.holders.computeIfAbsent(t.getId(), k -> new DynamicHolder(this, (ResourceLocation)k));
    }

    public DynamicHolder<R> emptyHolder() {
        return this.holders.computeIfAbsent(DynamicHolder.EMPTY, k -> new DynamicHolder(this, (ResourceLocation)k));
    }

    public Codec<DynamicHolder<R>> holderCodec() {
        return this.holderCodec;
    }

    public final void registerSerializer(ResourceLocation id, PSerializer<? extends R> serializer) {
        serializer.validate(false, this.synced);
        if (this.subtypes) {
            if (this.serializers.contains(id)) {
                throw new RuntimeException("Attempted to register a " + this.path + " serializer with id " + id + " but one already exists!");
            }
            this.serializers.register(id, serializer);
        } else {
            if (!this.serializers.isEmpty()) {
                throw new RuntimeException("Attempted to register a " + this.path + " serializer with id " + id + " but subtypes are not supported!");
            }
            this.serializers.register(DEFAULT, serializer);
        }
    }

    public final boolean addCallback(RegistryCallback<R> callback) {
        return this.callbacks.add(callback);
    }

    public final boolean removeCallback(RegistryCallback<R> callback) {
        return this.callbacks.remove(callback);
    }

    protected final void register(ResourceLocation key, R item) {
        if (!key.equals((Object)item.getId())) {
            throw new UnsupportedOperationException("Attempted to register a " + this.path + " with a mismatched registry ID! Expected: " + item.getId() + " Provided: " + key);
        }
        if (this.registry.containsKey(key)) {
            throw new UnsupportedOperationException("Attempted to register a " + this.path + " with a duplicate registry ID! Key: " + key);
        }
        this.validateItem(item);
        this.registry.put(key, item);
        this.holders.computeIfAbsent(key, k -> new DynamicHolder(this, (ResourceLocation)k));
    }

    protected void validateItem(R item) {
    }

    protected final ICondition.IContext getContext() {
        return this.context.get() != null ? (ICondition.IContext)this.context.get() : ICondition.IContext.EMPTY;
    }

    private void addReloader(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)this);
        this.context = new WeakReference<ICondition.IContext>(e.getConditionContext());
    }

    private void pushStagedToLive() {
        this.beginReload();
        this.staged.forEach(this::register);
        this.onReload();
    }

    private void sync(OnDatapackSyncEvent e) {
        ServerPlayer player = e.getPlayer();
        PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
        Placebo.CHANNEL.send(target, (Object)new ReloadListenerPacket.Start(this.path));
        this.registry.forEach((k, v) -> Placebo.CHANNEL.send(target, new ReloadListenerPacket.Content<TypeKeyed>(this.path, (ResourceLocation)k, (TypeKeyed)v)));
        Placebo.CHANNEL.send(target, (Object)new ReloadListenerPacket.End(this.path));
    }

    @ApiStatus.Internal
    static class SyncManagement {
        private static final Map<String, DynamicRegistry<?>> SYNC_REGISTRY = new LinkedHashMap();

        SyncManagement() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void registerForSync(DynamicRegistry<?> listener) {
            if (!listener.synced) {
                throw new UnsupportedOperationException("Attempted to register the non-synced JSON Reload Listener " + listener.path + " as a synced listener!");
            }
            Map<String, DynamicRegistry<?>> map = SYNC_REGISTRY;
            synchronized (map) {
                if (SYNC_REGISTRY.containsKey(listener.path)) {
                    throw new UnsupportedOperationException("Attempted to register the JSON Reload Listener for syncing " + listener.path + " but one already exists!");
                }
                if (SYNC_REGISTRY.isEmpty()) {
                    MinecraftForge.EVENT_BUS.addListener(SyncManagement::syncAll);
                }
                SYNC_REGISTRY.put(listener.path, listener);
            }
        }

        static void initSync(String path) {
            SyncManagement.ifPresent(path, (k, v) -> v.staged.clear());
            Placebo.LOGGER.info("Starting sync for {}", (Object)path);
        }

        static <V extends TypeKeyed & PSerializer.PSerializable<? super V>> void writeItem(String path, V value, FriendlyByteBuf buf) {
            SyncManagement.ifPresent(path, (k, v) -> v.serializers.write(value, buf));
        }

        static <V extends TypeKeyed> V readItem(String path, ResourceLocation key, FriendlyByteBuf buf) {
            DynamicRegistry<?> listener = SYNC_REGISTRY.get(path);
            if (listener == null) {
                throw new RuntimeException("Received sync packet for unknown registry!");
            }
            TypeKeyed v = (TypeKeyed)listener.serializers.read(buf);
            v.setId(key);
            return (V)v;
        }

        static <V extends TypeKeyed> void acceptItem(String path, V value) {
            SyncManagement.ifPresent(path, (k, v) -> v.staged.put(value.getId(), value));
        }

        static void endSync(String path) {
            if (ServerLifecycleHooks.getCurrentServer() != null) {
                return;
            }
            SyncManagement.ifPresent(path, (k, v) -> v.pushStagedToLive());
        }

        private static void ifPresent(String path, BiConsumer<String, DynamicRegistry<?>> consumer) {
            DynamicRegistry<?> value = SYNC_REGISTRY.get(path);
            if (value != null) {
                consumer.accept(path, value);
            }
        }

        private static void syncAll(OnDatapackSyncEvent e) {
            SYNC_REGISTRY.values().forEach(r -> r.sync(e));
        }
    }
}

