/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.reload;

import dev.shadowsoffire.placebo.json.PSerializer;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.reload.TypeKeyed;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class DynamicHolder<T extends TypeKeyed & PSerializer.PSerializable<? super T>>
implements Supplier<T> {
    public static final ResourceLocation EMPTY = new ResourceLocation("empty", "empty");
    protected final DynamicRegistry<? super T> registry;
    protected final ResourceLocation id;
    @Nullable
    protected T value;

    DynamicHolder(DynamicRegistry<? super T> registry, ResourceLocation id) {
        this.id = id;
        this.registry = registry;
    }

    public boolean isBound() {
        this.bind();
        return this.value != null;
    }

    @Override
    public T get() {
        this.bind();
        Objects.requireNonNull(this.value, "Trying to access unbound value: " + this.id);
        return this.value;
    }

    public Optional<T> getOptional() {
        return this.isBound() ? Optional.of(this.value()) : Optional.empty();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean is(ResourceLocation id) {
        return this.id.equals((Object)id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DynamicHolder)) return false;
        DynamicHolder dh = (DynamicHolder)obj;
        if (dh.registry != this.registry) return false;
        if (!dh.id.equals((Object)this.id)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.registry});
    }

    void bind() {
        if (this.value != null) {
            return;
        }
        this.value = this.registry.getValue(this.id);
    }

    void unbind() {
        this.value = null;
    }

    @Deprecated(forRemoval=true)
    public T value() {
        return (T)this.get();
    }
}

