/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.json;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonObject;
import dev.shadowsoffire.placebo.json.PSerializer;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class SerializerMap<V extends PSerializer.PSerializable<? super V>> {
    protected final String name;
    protected final String defaultDomain;
    private final BiMap<ResourceLocation, PSerializer<? extends V>> serializers = HashBiMap.create();

    public SerializerMap(String name, String defaultDomain) {
        this.name = name;
        this.defaultDomain = defaultDomain;
    }

    public SerializerMap(String name) {
        this(name, "minecraft");
    }

    public boolean isEmpty() {
        return this.serializers.isEmpty();
    }

    public boolean contains(ResourceLocation typeId) {
        return this.serializers.containsKey((Object)typeId);
    }

    @Nullable
    public PSerializer<? extends V> get(ResourceLocation typeId) {
        return (PSerializer)this.serializers.get((Object)typeId);
    }

    @Nullable
    public ResourceLocation get(PSerializer<?> serializer) {
        return (ResourceLocation)this.serializers.inverse().get(serializer);
    }

    public void register(ResourceLocation id, PSerializer<? extends V> serializer) {
        if (this.serializers.containsKey((Object)id)) {
            throw new RuntimeException("Attempted to register a " + this.name + " serializer with id " + id + " but one already exists!");
        }
        this.serializers.put((Object)id, serializer);
    }

    public V read(JsonObject obj) {
        if (obj.has("type")) {
            ResourceLocation type = this.defaultedReloc(obj.get("type").getAsString());
            PSerializer serializer = (PSerializer)this.serializers.get((Object)type);
            if (serializer == null) {
                throw new RuntimeException("Attempted to deserialize a " + this.name + " with type " + type + " but no serializer exists!");
            }
            return (V)((PSerializer.PSerializable)serializer.read(obj));
        }
        throw new RuntimeException("Attempted to deserialize a " + this.name + " with unknown type!");
    }

    public JsonObject write(V obj) {
        JsonObject json = obj.getSerializer().writeUnchecked(obj).getAsJsonObject();
        ResourceLocation type = this.get(obj.getSerializer());
        json.addProperty("type", type.toString());
        return json;
    }

    public V read(FriendlyByteBuf buf) {
        ResourceLocation type = buf.m_130281_();
        PSerializer serializer = (PSerializer)this.serializers.get((Object)type);
        return (V)((PSerializer.PSerializable)serializer.read(buf));
    }

    public void write(V obj, FriendlyByteBuf buf) {
        ResourceLocation type = this.get(obj.getSerializer());
        buf.m_130085_(type);
        obj.getSerializer().writeUnchecked(obj, buf);
    }

    private ResourceLocation defaultedReloc(String reloc) {
        if (reloc.indexOf(58) != -1) {
            return new ResourceLocation(reloc);
        }
        return new ResourceLocation(this.defaultDomain, reloc);
    }
}

