/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.placebo.json.NBTAdapter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemAdapter
implements JsonDeserializer<ItemStack>,
JsonSerializer<ItemStack> {
    public static final ItemAdapter INSTANCE = new ItemAdapter();
    public static final Gson ITEM_READER = new GsonBuilder().registerTypeAdapter(ItemStack.class, (Object)INSTANCE).registerTypeAdapter(CompoundTag.class, (Object)NBTAdapter.INSTANCE).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();
    public static final Codec<ItemStack> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(ItemStack::m_41720_), (App)Codec.intRange((int)0, (int)64).optionalFieldOf("count", (Object)1).forGetter(ItemStack::m_41613_), (App)CompoundTag.f_128325_.optionalFieldOf("nbt").forGetter(stack -> Optional.ofNullable(stack.m_41783_())), (App)CompoundTag.f_128325_.optionalFieldOf("cap_nbt").forGetter(ItemAdapter::getCapNBT)).apply((Applicative)inst, (item, count, nbt, capNbt) -> {
        ItemStack stack = new ItemStack((ItemLike)item, count.intValue(), (CompoundTag)capNbt.orElse(null));
        stack.m_41751_((CompoundTag)nbt.orElse(null));
        return stack;
    }));

    private static Optional<CompoundTag> getCapNBT(ItemStack stack) {
        CompoundTag written = stack.m_41739_(new CompoundTag());
        if (written.m_128441_("ForgeCaps")) {
            return Optional.of(written.m_128469_("ForgeCaps"));
        }
        return Optional.empty();
    }

    public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
        boolean optional;
        JsonObject obj = json.getAsJsonObject();
        ResourceLocation id = (ResourceLocation)ctx.deserialize(obj.get("item"), ResourceLocation.class);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
        boolean bl = optional = obj.has("optional") ? obj.get("optional").getAsBoolean() : false;
        if (!optional && item == Items.f_41852_ && !id.equals((Object)ForgeRegistries.ITEMS.getKey((Object)Items.f_41852_))) {
            throw new JsonParseException("Failed to read non-optional item " + id);
        }
        int count = obj.has("count") ? obj.get("count").getAsInt() : 1;
        CompoundTag tag = null;
        if (obj.has("nbt")) {
            JsonElement nbt = obj.get("nbt");
            tag = nbt.isJsonObject() ? (CompoundTag)((Pair)CompoundTag.f_128325_.decode((DynamicOps)JsonOps.INSTANCE, (Object)nbt).get().orThrow()).getFirst() : (CompoundTag)ctx.deserialize(obj.get("nbt"), CompoundTag.class);
        }
        CompoundTag capTag = obj.has("cap_nbt") ? (CompoundTag)ctx.deserialize(obj.get("cap_nbt"), CompoundTag.class) : null;
        ItemStack stack = new ItemStack((ItemLike)item, count, capTag);
        stack.m_41751_(tag);
        return stack;
    }

    public JsonElement serialize(ItemStack stack, Type typeOfSrc, JsonSerializationContext ctx) {
        CompoundTag written = stack.m_41739_(new CompoundTag());
        JsonObject obj = new JsonObject();
        obj.add("item", ctx.serialize((Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())));
        obj.add("count", ctx.serialize((Object)stack.m_41613_()));
        if (stack.m_41782_()) {
            obj.add("nbt", ctx.serialize((Object)stack.m_41783_()));
        }
        if (written.m_128441_("ForgeCaps")) {
            obj.add("cap_nbt", ctx.serialize((Object)written.m_128469_("ForgeCaps")));
        }
        return obj;
    }

    public static ItemStack readStack(JsonElement obj) {
        return (ItemStack)ITEM_READER.fromJson(obj, ItemStack.class);
    }

    public static List<ItemStack> readStacks(JsonElement obj) {
        return (List)ITEM_READER.fromJson(obj, new TypeToken<List<ItemStack>>(){}.getType());
    }
}

