/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.codec;

import com.google.common.collect.BiMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.json.ItemAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public class PlaceboCodecs {
    public static <T extends CodecProvider<T>> Codec<T> mapBackedDefaulted(String name, BiMap<ResourceLocation, Codec<? extends T>> reg, Codec<? extends T> defaultCodec) {
        return new MapBackedCodec<T>(name, reg, defaultCodec);
    }

    public static <T extends CodecProvider<T>> Codec<T> mapBacked(String name, BiMap<ResourceLocation, Codec<? extends T>> reg) {
        return new MapBackedCodec<T>(name, reg);
    }

    public static <T> Codec<Set<T>> setOf(Codec<T> elementCodec) {
        return PlaceboCodecs.setFromList(elementCodec.listOf());
    }

    public static <T> Codec<Set<T>> setFromList(Codec<List<T>> listCodec) {
        return listCodec.xmap(HashSet::new, ArrayList::new);
    }

    public static <E extends Enum<E>> Codec<E> enumCodec(Class<E> clazz) {
        return ExtraCodecs.m_184405_(e -> e.name().toLowerCase(Locale.ROOT), name -> Enum.valueOf(clazz, name.toUpperCase(Locale.ROOT)));
    }

    public static <T extends StringRepresentable> Codec<T> stringResolver(Function<String, T> decoder) {
        return ExtraCodecs.m_184405_(StringRepresentable::m_7912_, decoder);
    }

    @ApiStatus.Internal
    public static class MapBackedCodec<V extends CodecProvider<V>>
    implements Codec<V> {
        protected final String name;
        protected final BiMap<ResourceLocation, Codec<? extends V>> registry;
        @Nullable
        protected final Codec<? extends V> defaultCodec;

        public MapBackedCodec(String name, BiMap<ResourceLocation, Codec<? extends V>> registry, @Nullable Codec<? extends V> defaultCodec) {
            this.name = name;
            this.registry = registry;
            this.defaultCodec = defaultCodec;
        }

        public MapBackedCodec(String name, BiMap<ResourceLocation, Codec<? extends V>> registry) {
            this(name, registry, null);
        }

        public <T> DataResult<Pair<V, T>> decode(DynamicOps<T> ops, T input) {
            Optional type = ops.get(input, "type").resultOrPartial(str -> {});
            Optional<ResourceLocation> key = type.map(t -> (ResourceLocation)((Pair)ResourceLocation.f_135803_.decode(ops, t).resultOrPartial(arg_0 -> ((Logger)Placebo.LOGGER).error(arg_0)).get()).getFirst());
            Codec<? extends V> codec = key.map(arg_0 -> this.registry.get(arg_0)).orElse(this.defaultCodec);
            if (codec == null) {
                return DataResult.error(() -> "Failure when parsing a " + this.name + ". Unrecognized type: " + key.map(ResourceLocation::toString).orElse("null"));
            }
            return codec.decode(ops, input);
        }

        public <T> DataResult<T> encode(V input, DynamicOps<T> ops, T prefix) {
            Codec codec = input.getCodec();
            ResourceLocation key = (ResourceLocation)this.registry.inverse().get(codec);
            if (key == null) {
                return DataResult.error(() -> "Attempted to serialize an element of type " + this.name + " with an unregistered codec! Object: " + input);
            }
            Object encodedKey = ResourceLocation.f_135803_.encodeStart(ops, (Object)key).getOrThrow(false, arg_0 -> ((Logger)Placebo.LOGGER).error(arg_0));
            Object encodedObj = codec.encode(input, ops, prefix).getOrThrow(false, arg_0 -> ((Logger)Placebo.LOGGER).error(arg_0));
            return ops.mergeToMap(encodedObj, ops.createString("type"), encodedKey);
        }
    }

    public static interface CodecProvider<T> {
        public Codec<? extends T> getCodec();
    }

    public static class IngredientCodec
    implements Codec<Ingredient> {
        public static IngredientCodec INSTANCE = new IngredientCodec();
        private static Codec<List<ItemStack>> ITEM_LIST_CODEC = ItemAdapter.CODEC.listOf();

        public <T> DataResult<T> encode(Ingredient input, DynamicOps<T> ops, T prefix) {
            return ITEM_LIST_CODEC.encode(Arrays.asList(input.m_43908_()), ops, prefix);
        }

        public <T> DataResult<Pair<Ingredient, T>> decode(DynamicOps<T> ops, T input) {
            JsonElement j;
            JsonElement json = input instanceof JsonElement ? (j = (JsonElement)input) : (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input);
            try {
                return DataResult.success((Object)Pair.of((Object)CraftingHelper.getIngredient((JsonElement)json, (boolean)true), input));
            }
            catch (JsonSyntaxException ex) {
                return DataResult.error(ex::getMessage);
            }
        }
    }
}

