/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks;

import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.clienttweaks.ClientEventHandler;
import net.blay09.mods.clienttweaks.ClientTweaksConfig;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.blay09.mods.clienttweaks.tweak.AdditionalVolumeSlider;
import net.blay09.mods.clienttweaks.tweak.AutoClimbLadder;
import net.blay09.mods.clienttweaks.tweak.DisablePotionShift;
import net.blay09.mods.clienttweaks.tweak.DoNotUseLastTorch;
import net.blay09.mods.clienttweaks.tweak.HideOffhandItem;
import net.blay09.mods.clienttweaks.tweak.HideOwnEffectParticles;
import net.blay09.mods.clienttweaks.tweak.HideShieldUnlessHoldingWeapon;
import net.blay09.mods.clienttweaks.tweak.NoOffhandTorchWithBlock;
import net.blay09.mods.clienttweaks.tweak.NoOffhandTorchWithEmptyHand;
import net.blay09.mods.clienttweaks.tweak.OffhandTorchWithToolOnly;
import net.blay09.mods.clienttweaks.tweak.StepAssistIsAnnoying;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="clienttweaks")
public class ClientTweaks {
    public static final String MOD_ID = "clienttweaks";
    private static final Map<String, AbstractClientTweak> tweaks = new HashMap<String, AbstractClientTweak>();

    public ClientTweaks() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ClientTweaksConfig.clientSpec);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
    }

    private void setupClient(FMLClientSetupEvent event) {
        this.registerTweak(new AdditionalVolumeSlider("masterVolumeSlider", ClientTweaksConfig.CLIENT.masterVolumeSlider, SoundCategory.MASTER, 0));
        this.registerTweak(new AdditionalVolumeSlider("musicVolumeSlider", ClientTweaksConfig.CLIENT.musicVolumeSlider, SoundCategory.MUSIC, 160));
        this.registerTweak(new NoOffhandTorchWithBlock());
        this.registerTweak(new NoOffhandTorchWithEmptyHand());
        this.registerTweak(new OffhandTorchWithToolOnly());
        this.registerTweak(new HideOwnEffectParticles());
        this.registerTweak(new HideOffhandItem());
        this.registerTweak(new StepAssistIsAnnoying());
        this.registerTweak(new AutoClimbLadder());
        this.registerTweak(new DisablePotionShift());
        this.registerTweak(new HideShieldUnlessHoldingWeapon());
        this.registerTweak(new DoNotUseLastTorch());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientEventHandler.setupKeyBindings(tweaks.values());
    }

    private void registerTweak(AbstractClientTweak tweak) {
        tweaks.put(tweak.getName(), tweak);
    }
}

