/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.pcf.MQCFH;
import com.ibm.mq.pcf.MQCFIL;
import com.ibm.mq.pcf.MQCFIN;
import com.ibm.mq.pcf.MQCFSL;
import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFHeader;
import com.ibm.mq.pcf.PCFParameter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class PCFMessage
extends PCFHeader
implements Serializable {
    public static final String copyright = "Copyright (c) IBM Corp. 2000   All rights reserved.";
    MQCFH header;
    Vector parameters = new Vector(8, 8);

    public PCFMessage(int n) {
        this(1, n, 1, true);
    }

    public PCFMessage(int n, int n2, int n3, boolean bl) {
        this.header = new MQCFH(n2, 0);
        this.header.type = n;
        this.header.msgSeqNumber = n3;
        this.header.control = bl ? 1 : 0;
    }

    public PCFMessage(MQMessage mQMessage) throws MQException, IOException {
        this.initialize(mQMessage);
    }

    public void initialize(int n) {
        this.initialize(1, n, 1, true);
    }

    public void initialize(int n, int n2, int n3, boolean bl) {
        Vector vector = this.parameters;
        synchronized (vector) {
            this.header.type = 1;
            this.header.version = 1;
            this.header.command = n2;
            this.header.msgSeqNumber = n3;
            this.header.control = bl ? 1 : 0;
            this.header.compCode = 0;
            this.header.reason = 0;
            this.header.parameterCount = 0;
            this.parameters.removeAllElements();
        }
    }

    public void addParameter(PCFParameter pCFParameter) {
        Vector vector = this.parameters;
        synchronized (vector) {
            this.parameters.addElement(pCFParameter);
            ++this.header.parameterCount;
        }
    }

    public void addParameter(int n, int n2) {
        this.addParameter(new MQCFIN(n, n2));
    }

    public void addParameter(int n, int[] nArray) {
        this.addParameter(new MQCFIL(n, nArray));
    }

    public void addParameter(int n, String string) {
        this.addParameter(new MQCFST(n, string));
    }

    public void addParameter(int n, String[] stringArray) {
        this.addParameter(new MQCFSL(n, stringArray));
    }

    public int getCommand() {
        return this.header.command;
    }

    public int getMsgSeqNumber() {
        return this.header.msgSeqNumber;
    }

    public int getControl() {
        return this.header.control;
    }

    public int getCompCode() {
        return this.header.compCode;
    }

    public int getReason() {
        return this.header.reason;
    }

    public int getParameterCount() {
        return this.header.parameterCount;
    }

    public Enumeration getParameters() {
        return this.parameters.elements();
    }

    public Object getParameterValue(int n) {
        Object object = null;
        Vector vector = this.parameters;
        synchronized (vector) {
            int n2 = this.parameters.size();
            while (n2-- > 0) {
                PCFParameter pCFParameter = (PCFParameter)this.parameters.elementAt(n2);
                if (pCFParameter.getParameter() != n) continue;
                object = pCFParameter.getValue();
                n2 = 0;
            }
        }
        return object;
    }

    public int getIntParameterValue(int n) throws PCFException {
        Integer n2 = (Integer)this.getParameterValue(n);
        if (n2 == null) {
            throw new PCFException(2, 3014, this);
        }
        return n2;
    }

    public int[] getIntListParameterValue(int n) throws PCFException {
        int[] nArray = (int[])this.getParameterValue(n);
        if (nArray == null) {
            throw new PCFException(2, 3047, this);
        }
        return nArray;
    }

    public String getStringParameterValue(int n) throws PCFException {
        String string = (String)this.getParameterValue(n);
        if (string == null) {
            throw new PCFException(2, 3015, this);
        }
        return string;
    }

    public String[] getStringListParameterValue(int n) throws PCFException {
        String[] stringArray = (String[])this.getParameterValue(n);
        if (stringArray == null) {
            throw new PCFException(2, 2238, this);
        }
        return stringArray;
    }

    public void initialize(MQMessage mQMessage) throws MQException, IOException {
        Vector vector = this.parameters;
        synchronized (vector) {
            this.header = new MQCFH(mQMessage);
            this.parameters.removeAllElements();
            int n = this.header.parameterCount;
            this.header.parameterCount = 0;
            while (n-- > 0) {
                this.addParameter(PCFParameter.nextParameter(mQMessage));
            }
        }
    }

    public int write(MQMessage mQMessage) throws IOException {
        Vector vector = this.parameters;
        synchronized (vector) {
            int n = this.header.write(mQMessage);
            int n2 = this.parameters.size();
            int n3 = 0;
            while (n3 < n2) {
                PCFParameter pCFParameter = (PCFParameter)this.parameters.elementAt(n3);
                n += pCFParameter.write(mQMessage);
                ++n3;
            }
            int n4 = n;
            return n4;
        }
    }

    public int size() {
        Vector vector = this.parameters;
        synchronized (vector) {
            int n = this.header.size();
            int n2 = this.parameters.size();
            while (n2-- > 0) {
                PCFParameter pCFParameter = (PCFParameter)this.parameters.elementAt(n2);
                n += pCFParameter.size();
            }
            int n3 = n;
            return n3;
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof PCFMessage) {
            PCFMessage pCFMessage = (PCFMessage)object;
            if (pCFMessage.getParameterCount() == this.getParameterCount() && pCFMessage.header.equals(this.header)) {
                Enumeration enumeration = pCFMessage.getParameters();
                Enumeration enumeration2 = this.getParameters();
                boolean bl = true;
                try {
                    while (bl && enumeration2.hasMoreElements()) {
                        bl = enumeration.nextElement().equals(enumeration2.nextElement());
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    return false;
                }
                return bl;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName() + ": \n");
        Vector vector = this.parameters;
        synchronized (vector) {
            int n = this.parameters.size();
            stringBuffer.append(this.header.toString());
            while (n-- > 0) {
                stringBuffer.append(this.parameters.elementAt(n));
            }
        }
        return new String(stringBuffer);
    }
}

