/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.pcf.MQCFH;
import com.ibm.mq.pcf.PCFParameter;
import java.io.IOException;
import java.util.Vector;

public class PCFAgent {
    public static final String copyright = "Copyright (c) IBM Corp. 1998, 2003   All rights reserved.";
    static final String MODEL_QUEUE_NAME = "SYSTEM.DEFAULT.MODEL.QUEUE";
    final MQPutMessageOptions pmo = new MQPutMessageOptions();
    final MQGetMessageOptions gmo = new MQGetMessageOptions();
    public String replyQueueName;
    protected int expiryTime = 300;
    protected int waitInterval = 30000;
    protected int encoding = 273;
    protected int ccsid = 0;
    protected MQQueueManager qmanager;
    protected int qmanager_level;
    protected String qmanager_name;
    protected MQQueue adminQueue;
    protected MQQueue replyQueue;

    public PCFAgent() {
    }

    public PCFAgent(MQQueueManager mQQueueManager) throws MQException {
        this();
        this.connect(mQQueueManager);
    }

    public PCFAgent(String string, int n, String string2) throws MQException {
        this();
        this.connect(string, n, string2);
    }

    public PCFAgent(String string) throws MQException {
        this();
        this.connect(string);
    }

    public synchronized void connect(MQQueueManager mQQueueManager) throws MQException {
        this.open(mQQueueManager, true);
    }

    public synchronized void connect(MQQueueManager mQQueueManager, String string, String string2) throws MQException {
        this.open(mQQueueManager, string, string2, true);
    }

    public synchronized void connect(String string, int n, String string2) throws MQException {
        MQEnvironment.hostname = string;
        MQEnvironment.port = n;
        MQEnvironment.channel = string2;
        this.open(new MQQueueManager(""), false);
    }

    public synchronized void connect(String string, int n, String string2, String string3, String string4) throws MQException {
        MQEnvironment.hostname = string;
        MQEnvironment.port = n;
        MQEnvironment.channel = string2;
        this.open(new MQQueueManager(""), string3, string4, false);
    }

    public synchronized void connect(String string) throws MQException {
        MQEnvironment.hostname = null;
        MQEnvironment.port = 1414;
        MQEnvironment.channel = null;
        this.open(new MQQueueManager(string), false);
    }

    public synchronized void connect(String string, String string2, String string3) throws MQException {
        MQEnvironment.hostname = null;
        MQEnvironment.port = 1414;
        MQEnvironment.channel = null;
        this.open(new MQQueueManager(string), string2, string3, false);
    }

    protected synchronized void open(MQQueueManager mQQueueManager, boolean bl) throws MQException {
        this.open(mQQueueManager, null, null, bl);
    }

    protected synchronized void open(MQQueueManager mQQueueManager, String string, String string2, boolean bl) throws MQException {
        try {
            this.disconnect();
        }
        catch (MQException mQException) {
            // empty catch block
        }
        if (string == null || string.length() == 0) {
            string = mQQueueManager.getCommandInputQueueName();
        }
        this.adminQueue = mQQueueManager.accessQueue(string, 16, string2, "", "mqm");
        this.replyQueue = mQQueueManager.accessQueue(MODEL_QUEUE_NAME, 4, "", "", "mqm");
        this.replyQueueName = this.replyQueue.name;
        if (!bl) {
            this.qmanager = mQQueueManager;
        }
        try {
            int[] nArray = new int[1];
            byte[] byArray = new byte[48];
            mQQueueManager.inquire(new int[]{31, 2015}, nArray, byArray);
            this.qmanager_level = nArray[0];
            this.qmanager_name = new String(byArray).trim();
        }
        catch (MQException mQException) {
            this.qmanager_level = 0;
            this.qmanager_name = null;
        }
    }

    public synchronized void disconnect() throws MQException {
        try {
            block5: {
                try {
                    if (this.qmanager != null) {
                        this.qmanager.disconnect();
                        break block5;
                    }
                    this.adminQueue.close();
                    this.replyQueue.close();
                }
                catch (NullPointerException nullPointerException) {
                    Object var3_2 = null;
                    this.adminQueue = null;
                    this.replyQueue = null;
                    this.replyQueueName = null;
                    this.qmanager = null;
                    this.qmanager_name = null;
                }
            }
            Object var3_1 = null;
            this.adminQueue = null;
            this.replyQueue = null;
            this.replyQueueName = null;
            this.qmanager = null;
            this.qmanager_name = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.adminQueue = null;
            this.replyQueue = null;
            this.replyQueueName = null;
            this.qmanager = null;
            this.qmanager_name = null;
            throw throwable;
        }
    }

    public synchronized MQMessage[] send(int n, PCFParameter[] pCFParameterArray) throws MQException, IOException {
        MQMessage mQMessage = new MQMessage();
        Vector<MQMessage> vector = new Vector<MQMessage>();
        boolean bl = false;
        if (this.qmanager_level < 500) {
            mQMessage.setVersion(1);
        }
        mQMessage.messageType = 1;
        mQMessage.expiry = this.expiryTime;
        mQMessage.feedback = 0;
        mQMessage.format = "MQADMIN ";
        mQMessage.encoding = this.encoding;
        mQMessage.characterSet = this.ccsid;
        mQMessage.replyToQueueName = this.replyQueueName;
        mQMessage.replyToQueueManagerName = this.qmanager_name;
        if (pCFParameterArray == null) {
            MQCFH.write(mQMessage, n, 0);
        } else {
            MQCFH.write(mQMessage, n, pCFParameterArray.length);
            int n2 = 0;
            while (n2 < pCFParameterArray.length) {
                pCFParameterArray[n2].write(mQMessage);
                ++n2;
            }
        }
        this.adminQueue.put(mQMessage, this.pmo);
        byte[] byArray = mQMessage.correlationId;
        this.gmo.options = 16385;
        this.gmo.waitInterval = this.waitInterval;
        do {
            mQMessage = new MQMessage();
            mQMessage.correlationId = byArray;
            mQMessage.encoding = this.encoding;
            mQMessage.characterSet = this.ccsid;
            this.replyQueue.get(mQMessage, this.gmo);
            vector.addElement(mQMessage);
            bl = new MQCFH((MQMessage)mQMessage).control == 1;
            mQMessage.seek(0);
        } while (!bl);
        Object[] objectArray = new MQMessage[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setWaitInterval(int n) {
        if (n >= 0) {
            this.expiryTime = n * 10;
            this.waitInterval = n * 1000;
        }
    }

    public String getQManagerName() {
        return this.qmanager_name;
    }

    public String getReplyQueueName() {
        return this.replyQueueName;
    }

    public void setEncoding(int n) {
        this.encoding = n;
    }

    public void setCharacterSet(int n) {
        this.ccsid = n;
    }
}

