/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.pcf.PCFParameter;
import java.io.IOException;

public class MQCFST
extends PCFParameter {
    public static final String copyright = "Copyright (c) IBM Corp. 1998, 2000   All rights reserved.";
    static final String[] pads = new String[]{"", " ", "  ", "   ", ""};
    public static final int type = 4;
    public int strucLength = 20;
    public int parameter;
    public int codedCharSetId;
    public int stringLength;
    public String string;

    public static int write(MQMessage mQMessage, int n, String string) throws IOException {
        int n2 = string == null ? 0 : string.length();
        int n3 = n2 % 4;
        if (n3 != 0) {
            n3 = 4 - n3;
        }
        int n4 = 20 + n2 + n3;
        mQMessage.writeString("");
        mQMessage.writeInt(4);
        mQMessage.writeInt(n4);
        mQMessage.writeInt(n);
        mQMessage.writeInt(mQMessage.characterSet);
        mQMessage.writeInt(n2);
        mQMessage.writeString(string);
        if (n3 != 0) {
            mQMessage.writeString(pads[n3]);
        }
        return n4;
    }

    public MQCFST() {
        this.setString("");
    }

    public MQCFST(int n, String string) {
        this.parameter = n;
        this.setString(string);
    }

    public MQCFST(MQMessage mQMessage) throws MQException, IOException {
        this.initialize(mQMessage);
    }

    public void initialize(MQMessage mQMessage) throws MQException, IOException {
        int n = mQMessage.readInt();
        if (n != 4) {
            throw new MQException(2, 3013, (Object)mQMessage);
        }
        this.strucLength = mQMessage.readInt();
        this.parameter = mQMessage.readInt();
        this.codedCharSetId = mQMessage.readInt();
        this.stringLength = mQMessage.readInt();
        this.string = mQMessage.readString(this.stringLength);
        if (this.stringLength < 0) {
            throw new MQException(2, 3011, (Object)mQMessage);
        }
        if (this.strucLength < 20 + this.stringLength) {
            throw new MQException(2, 3010, (Object)mQMessage);
        }
        int n2 = this.strucLength - 20 - this.stringLength;
        while (n2-- > 0) {
            mQMessage.readByte();
        }
    }

    public int write(MQMessage mQMessage) throws IOException {
        int n = this.string == null ? 0 : this.string.length();
        int n2 = n % 4;
        if (n2 != 0) {
            n2 = 4 - n2;
        }
        mQMessage.writeString("");
        mQMessage.writeInt(4);
        mQMessage.writeInt(this.strucLength);
        mQMessage.writeInt(this.parameter);
        mQMessage.writeInt(mQMessage.characterSet);
        mQMessage.writeInt(this.stringLength);
        mQMessage.writeString(this.string);
        if (n2 != 0) {
            mQMessage.writeString(pads[n2]);
        }
        return 20 + n + n2;
    }

    public int size() {
        int n = this.string == null ? 0 : this.string.length();
        int n2 = n % 4;
        if (n2 != 0) {
            n2 = 4 - n2;
        }
        return 20 + n + n2;
    }

    public int getType() {
        return 4;
    }

    public int getParameter() {
        return this.parameter;
    }

    public Object getValue() {
        return this.string;
    }

    public String getStringValue() {
        if (this.string == null) {
            return "";
        }
        return this.string;
    }

    public void setValue(Object object) throws ClassCastException {
        this.setString((String)object);
    }

    public void setString(String string) {
        int n = string == null ? 0 : string.length();
        int n2 = n % 4;
        if (n2 != 0) {
            n2 = 4 - n2;
        }
        this.strucLength = 20 + n + n2;
        this.stringLength = n;
        this.string = string;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MQCFST) {
            MQCFST mQCFST = (MQCFST)object;
            String string = mQCFST.string;
            String string2 = this.string;
            return mQCFST.parameter == this.parameter && string != null && string2 != null && string.equals(string2);
        }
        return false;
    }

    public String toString() {
        return new String(this.getClass().getName() + ":\n" + "   - type: " + 4 + "\n" + "   - strucLength: " + this.strucLength + "\n" + "   - parameter: " + this.parameter + "\n" + "   - codedCharSetId: " + this.codedCharSetId + "\n" + "   - stringLength: " + this.stringLength + "\n" + "   - string: " + (this.string != null ? "'" + this.string + "'" : "null") + "\n");
    }
}

