/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.pcf.PCFParameter;
import java.io.IOException;

public class MQCFSL
extends PCFParameter {
    public static final String copyright = "Copyright (c) IBM Corp. 1998, 2000   All rights reserved.";
    public static final int type = 6;
    public int strucLength;
    public int parameter;
    public int codedCharSetId;
    public int count;
    public int stringLength;
    public String[] strings;

    public static int write(MQMessage mQMessage, int n, String[] stringArray) throws IOException {
        int n2 = stringArray == null ? 0 : stringArray.length;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < n2) {
            if (stringArray[n4].length() > n3) {
                n3 = stringArray[n4].length();
            }
            ++n4;
        }
        int n5 = n2 * n3 % 4;
        if (n5 != 0) {
            n5 = 4 - n5;
        }
        mQMessage.writeString("");
        mQMessage.writeInt(6);
        mQMessage.writeInt(24 + n2 * n3 + n5);
        mQMessage.writeInt(n);
        mQMessage.writeInt(mQMessage.characterSet);
        mQMessage.writeInt(n2);
        mQMessage.writeInt(n3);
        int n6 = 0;
        while (n6 < n2) {
            mQMessage.writeString(stringArray[n6]);
            int n7 = n3 - stringArray[n6].length();
            while (n7 > 0) {
                stringBuffer.append(' ');
                --n7;
            }
            if (stringBuffer.length() > 0) {
                mQMessage.writeString(new String(stringBuffer));
                stringBuffer.setLength(0);
            }
            ++n6;
        }
        while (n5-- > 0) {
            stringBuffer.append(' ');
        }
        if (stringBuffer.length() > 0) {
            mQMessage.writeString(new String(stringBuffer));
        }
        return 24 + n2 * n3 + n5;
    }

    public MQCFSL() {
    }

    public MQCFSL(int n, String[] stringArray) {
        this.parameter = n;
        this.setStrings(stringArray);
    }

    public MQCFSL(MQMessage mQMessage) throws MQException, IOException {
        this.initialize(mQMessage);
    }

    public void initialize(MQMessage mQMessage) throws MQException, IOException {
        int n = mQMessage.readInt();
        if (n != 6) {
            throw new MQException(2, 3013, (Object)mQMessage);
        }
        this.strucLength = mQMessage.readInt();
        this.parameter = mQMessage.readInt();
        this.codedCharSetId = mQMessage.readInt();
        this.count = mQMessage.readInt();
        this.stringLength = mQMessage.readInt();
        if (this.count < 0) {
            throw new MQException(2, 2238, (Object)mQMessage);
        }
        if (this.stringLength < 0) {
            throw new MQException(2, 2238, (Object)mQMessage);
        }
        if (this.strucLength < 24 + this.count * this.stringLength) {
            throw new MQException(2, 3067, (Object)mQMessage);
        }
        this.strings = new String[this.count];
        int n2 = 0;
        while (n2 < this.count) {
            this.strings[n2] = mQMessage.readString(this.stringLength);
            ++n2;
        }
        int n3 = this.strucLength - 24 - this.count * this.stringLength;
        while (n3-- > 0) {
            mQMessage.readByte();
        }
    }

    public int write(MQMessage mQMessage) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.count * this.stringLength % 4;
        if (n != 0) {
            n = 4 - n;
        }
        mQMessage.writeString("");
        mQMessage.writeInt(6);
        mQMessage.writeInt(this.strucLength);
        mQMessage.writeInt(this.parameter);
        mQMessage.writeInt(mQMessage.characterSet);
        mQMessage.writeInt(this.count);
        mQMessage.writeInt(this.stringLength);
        int n2 = 0;
        while (n2 < this.count) {
            mQMessage.writeString(this.strings[n2]);
            int n3 = this.stringLength - this.strings[n2].length();
            while (n3 > 0) {
                stringBuffer.append(' ');
                --n3;
            }
            if (stringBuffer.length() > 0) {
                mQMessage.writeString(new String(stringBuffer));
                stringBuffer.setLength(0);
            }
            ++n2;
        }
        while (n-- > 0) {
            stringBuffer.append(' ');
        }
        if (stringBuffer.length() > 0) {
            mQMessage.writeString(new String(stringBuffer));
        }
        return 24 + this.count * this.stringLength + n;
    }

    public int size() {
        return this.strucLength;
    }

    public int getType() {
        return 6;
    }

    public int getParameter() {
        return this.parameter;
    }

    public Object getValue() {
        try {
            return this.strings.clone();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getStringValue() {
        if (this.strings == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.strings.length) {
            stringBuffer.append(this.strings[n]);
            stringBuffer.append('\n');
            ++n;
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return new String(stringBuffer);
    }

    public void setValue(Object object) throws ClassCastException {
        this.setStrings((String[])object);
    }

    public void setStrings(String[] stringArray) {
        try {
            int n = stringArray.length;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                if (stringArray[n3].length() > n2) {
                    n2 = stringArray[n3].length();
                }
                ++n3;
            }
            int n4 = n * n2 % 4;
            if (n4 != 0) {
                n4 = 4 - n4;
            }
            this.stringLength = n2;
            this.strucLength = 24 + n * n2 + n4;
            this.strings = stringArray;
            this.count = n;
        }
        catch (NullPointerException nullPointerException) {
            this.stringLength = 0;
            this.strucLength = 24;
            this.strings = new String[0];
            this.count = 0;
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MQCFSL) {
            MQCFSL mQCFSL = (MQCFSL)object;
            String[] stringArray = mQCFSL.strings;
            String[] stringArray2 = this.strings;
            if (mQCFSL.parameter == this.parameter && stringArray != null && stringArray2 != null && stringArray.length == stringArray2.length) {
                int n = stringArray2.length;
                boolean bl = true;
                while (bl && n-- > 0) {
                    if (stringArray[n] != null) {
                        bl = stringArray[n].equals(stringArray2[n]);
                        continue;
                    }
                    boolean bl2 = bl = stringArray2[n] == null;
                }
                return bl;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("\n   - type: 6");
        stringBuffer.append("\n   - strucLength: " + this.strucLength);
        stringBuffer.append("\n   - parameter: " + this.parameter);
        stringBuffer.append("\n   - codedCharSetId: " + this.codedCharSetId);
        stringBuffer.append("\n   - count: " + this.count);
        stringBuffer.append("\n   - stringLength: " + this.stringLength);
        stringBuffer.append("\n   - strings: ");
        try {
            int n = 0;
            while (n < this.strings.length) {
                stringBuffer.append("\n\t'" + this.strings[n] + '\'');
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {
            stringBuffer.append("null");
        }
        return new String(stringBuffer);
    }
}

