/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.pcf.PCFParameter;
import java.io.IOException;

public class MQCFIN
extends PCFParameter {
    public static final String copyright = "Copyright (c) IBM Corp. 1998   All rights reserved.";
    public static final int type = 3;
    public static final int strucLength = 16;
    public int parameter;
    public int value;

    public static int write(MQMessage mQMessage, int n, int n2) throws IOException {
        mQMessage.writeInt(3);
        mQMessage.writeInt(16);
        mQMessage.writeInt(n);
        mQMessage.writeInt(n2);
        return 16;
    }

    public MQCFIN() {
    }

    public MQCFIN(int n, int n2) {
        this.parameter = n;
        this.setValue(n2);
    }

    public MQCFIN(MQMessage mQMessage) throws MQException, IOException {
        this.initialize(mQMessage);
    }

    public void initialize(MQMessage mQMessage) throws MQException, IOException {
        if (mQMessage.readInt() != 3) {
            throw new MQException(2, 3013, (Object)mQMessage);
        }
        if (mQMessage.readInt() != 16) {
            throw new MQException(2, 3009, (Object)mQMessage);
        }
        this.parameter = mQMessage.readInt();
        this.value = mQMessage.readInt();
    }

    public int write(MQMessage mQMessage) throws IOException {
        mQMessage.writeInt(3);
        mQMessage.writeInt(16);
        mQMessage.writeInt(this.parameter);
        mQMessage.writeInt(this.value);
        return 16;
    }

    public int size() {
        return 16;
    }

    public int getType() {
        return 3;
    }

    public int getParameter() {
        return this.parameter;
    }

    public Object getValue() {
        return new Integer(this.value);
    }

    public String getStringValue() {
        return Integer.toString(this.value);
    }

    public void setValue(Object object) throws ClassCastException {
        this.setValue((Integer)object);
    }

    public void setValue(int n) {
        this.value = n;
    }

    public void setValue(Integer n) {
        try {
            this.value = n;
        }
        catch (NullPointerException nullPointerException) {
            this.value = 0;
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MQCFIN) {
            MQCFIN mQCFIN = (MQCFIN)object;
            return mQCFIN.parameter == this.parameter && mQCFIN.value == this.value;
        }
        return false;
    }

    public String toString() {
        return new String(this.getClass().getName() + ":\n" + "   - type: " + 3 + "\n" + "   - strucLength: " + 16 + "\n" + "   - parameter: " + this.parameter + "\n" + "   - value: " + this.value + "\n");
    }
}

