/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.pcf.PCFParameter;
import java.io.IOException;

public class MQCFIL
extends PCFParameter {
    public static final String copyright = "Copyright (c) IBM Corp. 1998   All rights reserved.";
    public static final int type = 5;
    public int strucLength = 16;
    public int parameter;
    public int count;
    public int[] values;

    public static int write(MQMessage mQMessage, int n, int[] nArray) throws IOException {
        int n2 = nArray == null ? 0 : nArray.length;
        mQMessage.writeInt(5);
        mQMessage.writeInt(16 + n2 * 4);
        mQMessage.writeInt(n);
        mQMessage.writeInt(n2);
        int n3 = 0;
        while (n3 < n2) {
            mQMessage.writeInt(nArray[n3]);
            ++n3;
        }
        return 16 + n2 * 4;
    }

    public MQCFIL() {
    }

    public MQCFIL(int n, int[] nArray) {
        this.parameter = n;
        this.setValues(nArray);
    }

    public MQCFIL(MQMessage mQMessage) throws MQException, IOException {
        this.initialize(mQMessage);
    }

    public void initialize(MQMessage mQMessage) throws MQException, IOException {
        if (mQMessage.readInt() != 5) {
            throw new MQException(2, 3013, (Object)mQMessage);
        }
        this.strucLength = mQMessage.readInt();
        this.parameter = mQMessage.readInt();
        this.count = mQMessage.readInt();
        if (this.count < 0) {
            throw new MQException(2, 3027, (Object)mQMessage);
        }
        if (this.strucLength != 16 + this.count * 4) {
            throw new MQException(2, 3028, (Object)mQMessage);
        }
        this.values = new int[this.count];
        int n = 0;
        while (n < this.count) {
            this.values[n] = mQMessage.readInt();
            ++n;
        }
    }

    public int write(MQMessage mQMessage) throws IOException {
        int n = this.values == null ? 0 : this.values.length;
        mQMessage.writeInt(5);
        mQMessage.writeInt(this.strucLength);
        mQMessage.writeInt(this.parameter);
        mQMessage.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            mQMessage.writeInt(this.values[n2]);
            ++n2;
        }
        return 16 + n * 4;
    }

    public int size() {
        return this.strucLength;
    }

    public int getType() {
        return 5;
    }

    public int getParameter() {
        return this.parameter;
    }

    public Object getValue() {
        try {
            return this.values.clone();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getStringValue() {
        if (this.values == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.values.length) {
            stringBuffer.append(this.values[n]);
            stringBuffer.append('\n');
            ++n;
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length());
        }
        return new String(stringBuffer);
    }

    public void setValue(Object object) throws ClassCastException {
        this.setValues((int[])object);
    }

    public void setValues(int[] nArray) {
        int n = nArray == null ? 0 : nArray.length;
        this.strucLength = 16 + n * 4;
        this.count = n;
        this.values = nArray;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MQCFIL) {
            MQCFIL mQCFIL = (MQCFIL)object;
            int[] nArray = mQCFIL.values;
            int[] nArray2 = this.values;
            if (mQCFIL.parameter == this.parameter && nArray != null && nArray2 != null && nArray.length == nArray2.length) {
                int n = nArray2.length;
                boolean bl = true;
                while (bl && n-- > 0) {
                    boolean bl2 = bl = nArray[n] == nArray2[n];
                }
                return bl;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName() + ": ");
        stringBuffer.append("\n   - type: 5");
        stringBuffer.append("\n   - strucLength: " + this.strucLength);
        stringBuffer.append("\n   - parameter: " + this.parameter);
        stringBuffer.append("\n   - count: " + this.count);
        stringBuffer.append("\n   - values: ");
        try {
            int n = 0;
            while (n < this.values.length) {
                stringBuffer.append("\n\t" + this.values[n]);
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {
            stringBuffer.append("null");
        }
        stringBuffer.append('\n');
        return new String(stringBuffer);
    }
}

