/*
 * Decompiled with CFR 0.152.
 */
package soapical.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import soapical.util.EncodingDetector;

public class XMLInputStreamReader
extends Reader {
    static final String PS_QT = "(\"|')";
    static final String PS_WS = "\\s*";
    static final String PS_EQ = "\\s*=\\s*";
    static final String PS_VER_BEGIN = "\\s*version";
    static final String PS_VER_VALUE = "([a-zA-Z0-9_.:]|-)+";
    static final String PS_VER = "\\s*version\\s*=\\s*(\"|')([a-zA-Z0-9_.:]|-)+(\"|')";
    static final String PS_ENC_BEGIN = "\\s*encoding\\s*=\\s*";
    static final String PS_ENC_VALUE = "[A-Za-z]([A-Za-z0-9._]|-)*";
    static final String PS_ENC = "\\s*encoding\\s*=\\s*\\s*=\\s*(\"|')[A-Za-z]([A-Za-z0-9._]|-)*(\"|')";
    static final String PS_STANDALONE = "\\s*standalone\\s*=\\s*(\"|')(yes|no)(\"|')";
    static final String PS_XML_BEGIN = ".?<\\?xml\\s*version\\s*=\\s*(\"|')([a-zA-Z0-9_.:]|-)+(\"|')";
    static final String PS_XML_END = "\\s*\\?>";
    static final String PS_XML = ".?<\\?xml\\s*version\\s*=\\s*(\"|')([a-zA-Z0-9_.:]|-)+(\"|')(\\s*encoding\\s*=\\s*\\s*=\\s*(\"|')[A-Za-z]([A-Za-z0-9._]|-)*(\"|'))?(\\s*standalone\\s*=\\s*(\"|')(yes|no)(\"|'))?\\s*\\?>";
    private static final Pattern P_XML_BEGIN = Pattern.compile("^.?<\\?xml\\s*version\\s*=\\s*(\"|')([a-zA-Z0-9_.:]|-)+(\"|')");
    private static final Pattern P_ENC_BEGIN = Pattern.compile("^\\s*encoding\\s*=\\s*(\"|')");
    private static final Pattern P_ENC_END = Pattern.compile("(.*)(\"|')");
    static final Pattern P_XML = Pattern.compile(".?<\\?xml\\s*version\\s*=\\s*(\"|')([a-zA-Z0-9_.:]|-)+(\"|')(\\s*encoding\\s*=\\s*\\s*=\\s*(\"|')[A-Za-z]([A-Za-z0-9._]|-)*(\"|'))?(\\s*standalone\\s*=\\s*(\"|')(yes|no)(\"|'))?\\s*\\?>");
    InputStream _input;
    InputStreamReader _reader;
    static Logger _logger = Logger.getLogger(XMLInputStreamReader.class);
    static final String DEFAULT_ENCODING = "utf-8";
    static final EncodingDetector[] _encodings = new EncodingDetector[]{new EncodingDetector("00 00 fe ff", "UCS-4"), new EncodingDetector("ff fe 00 00", "UCS-4"), new EncodingDetector("00 00 ff fe", "UCS-4"), new EncodingDetector("fe ff 00 00", "UCS-4"), new EncodingDetector("00 3c 00 3f", "UTF-16BE"), new EncodingDetector("fe ff", "UTF-16BE"), new EncodingDetector("3c 00 3f 00", "UTF-16LE"), new EncodingDetector("ff fe", "UTF-16LE"), new EncodingDetector("3c 3f 78 6d", "UTF-8"), new EncodingDetector("ef bb bf", "UTF-8"), new EncodingDetector("4c 6f a7 94", "EDCDIC")};

    public XMLInputStreamReader(InputStream is) throws UnsupportedEncodingException, IOException {
        this._input = is;
        String encoding = this.detectEncoding();
        this._reader = new InputStreamReader(this._input, encoding);
    }

    String detectEncoding() throws IOException {
        int bytesWanted = 128;
        byte[] prolog = new byte[bytesWanted];
        this._input = new PushbackInputStream(this._input, bytesWanted);
        PushbackInputStream pis = (PushbackInputStream)this._input;
        int bytesRead = pis.read(prolog, 0, bytesWanted);
        pis.unread(prolog, 0, bytesRead);
        if (bytesRead < 4) {
            return DEFAULT_ENCODING;
        }
        EncodingDetector encodingType = null;
        int i = 0;
        while (i < _encodings.length) {
            if (_encodings[i].matches(prolog)) {
                encodingType = _encodings[i];
                break;
            }
            ++i;
        }
        if (encodingType == null) {
            return DEFAULT_ENCODING;
        }
        String encodingFamily = encodingType.name();
        String encoding = null;
        while (true) {
            String prologString;
            if ((encoding = XMLInputStreamReader.detectEncoding(prologString = new String(prolog, encodingFamily))) != null) {
                return encoding;
            }
            if (XMLInputStreamReader.hasXMLDecl(prologString) || bytesRead < bytesWanted) break;
            this._input = new PushbackInputStream(this._input, bytesWanted += 128);
            pis = (PushbackInputStream)this._input;
            prolog = new byte[bytesWanted];
            bytesRead = pis.read(prolog, 0, bytesWanted);
            pis.unread(prolog, 0, bytesRead);
        }
        return DEFAULT_ENCODING;
    }

    public static String detectEncoding(String prolog) {
        Matcher m;
        boolean matchFound;
        _logger.debug((Object)("Enter: detectEncoding: " + prolog));
        String current = prolog;
        String previous = prolog;
        previous = current;
        current = P_XML_BEGIN.matcher(previous).replaceFirst("");
        if (current.equals(previous)) {
            _logger.debug((Object)"Exit: detectEncoding (no xml begin)");
            return null;
        }
        previous = current;
        if (!(current = P_ENC_BEGIN.matcher(previous).replaceFirst("")).equals(previous) && (matchFound = (m = P_ENC_END.matcher(current)).lookingAt())) {
            String encoding = m.group(1);
            _logger.debug((Object)("Exit: detectEncoding (found " + encoding + ")"));
            return encoding;
        }
        _logger.debug((Object)"Exit: detectEncoding (no encoding found)");
        return null;
    }

    public static boolean hasXMLDecl(String prolog) {
        return P_XML.matcher(prolog).lookingAt();
    }

    public int read(char[] buf, int off, int len) throws IOException {
        return this._reader.read(buf, off, len);
    }

    public void close() throws IOException {
        this._reader.close();
    }
}

