/*
 * Decompiled with CFR 0.152.
 */
package soapical.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import soapical.util.MultiReader;

public class PrettyXML {
    static final int COPY_BUFFER_SIZE = 1024;
    static final String STYLESHEET_ROOT = "/soapical/util/xmlverbatim";
    static final String XSLT_STYLESHEET = "/soapical/util/xmlverbatim.xsl";
    static final String CSS_STYLESHEET = "/soapical/util/xmlverbatim.css";
    static Logger _logger = Logger.getLogger(PrettyXML.class);
    static Transformer _transformer = null;
    static String _errorMsg = "";
    static String _cssContents = "";
    boolean _hasError = _transformer == null;

    static {
        InputStream stylesheet = PrettyXML.class.getResourceAsStream(XSLT_STYLESHEET);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        if (stylesheet == null) {
            _errorMsg = "could not load resource /soapical/util/xmlverbatim.xsl";
            _logger.error((Object)_errorMsg);
        } else {
            StreamSource xslSource = new StreamSource(stylesheet);
            try {
                _transformer = tFactory.newTransformer(xslSource);
            }
            catch (TransformerConfigurationException tcx) {
                _logger.error((Object)"", (Throwable)tcx);
            }
        }
        InputStream cssStylesheet = PrettyXML.class.getResourceAsStream(CSS_STYLESHEET);
        if (cssStylesheet == null) {
            _errorMsg = "could not load resource /soapical/util/xmlverbatim.css";
            _logger.error((Object)_errorMsg);
        } else {
            try {
                InputStreamReader cssReader = new InputStreamReader(cssStylesheet);
                _cssContents = MultiReader.toString(cssReader);
            }
            catch (IOException ix) {
                _logger.error((Object)"", (Throwable)ix);
            }
        }
    }

    public static void writeFancily(Reader reader, Writer writer) throws IOException {
        String contents = MultiReader.toString(reader);
        if (_transformer == null) {
            writer.write(PrettyXML.formatError(_errorMsg));
            PrettyXML.writeBoringly(reader, writer);
        } else {
            try {
                StringReader copy = new StringReader(contents);
                _transformer.transform(new StreamSource(copy), new StreamResult(writer));
            }
            catch (TransformerException tx) {
                _logger.error((Object)tx);
                writer.write(PrettyXML.formatError(tx.getMessage()));
                writer.write("<hr>\n");
                writer.write(PrettyXML.toSimpleHTML(contents));
            }
        }
    }

    public static void writeBoringly(Reader reader, Writer writer) throws IOException {
        String contents = MultiReader.toString(reader);
        writer.write(PrettyXML.toSimpleHTML(contents));
    }

    public static String getFancyCSS() {
        return _cssContents;
    }

    public static String formatError(String error) {
        return "<font color=\"red\">\nError " + error + "\n" + "</font><br>\n";
    }

    public static String toSimpleHTML(String string) {
        String output = string;
        output = output.replaceAll("<", "&lt;");
        output = output.replaceAll(">", "&gt;");
        output = output.replaceAll("\n", "<br>\n");
        return output;
    }
}

