/*
 * Decompiled with CFR 0.152.
 */
package soapical.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Logger;

public class MultiReader
extends Reader {
    static Logger _logger = Logger.getLogger(MultiReader.class);
    private StringBuffer _buffer = new StringBuffer();
    private Reader _reader;
    private boolean _isClosed;
    private boolean _isUntouched;
    static final int COPY_BUFFER_SIZE = 1024;

    public MultiReader(Reader reader) {
        this._reader = reader;
        this._isClosed = false;
        this._isUntouched = true;
    }

    public static String toString(Reader reader) throws IOException {
        return new MultiReader(reader).getCopyAsString();
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void reopen() throws IOException {
        if (!this._isClosed) {
            throw new IOException("stream not closed yet");
        }
        this._isClosed = false;
        this._reader = this.getCopy();
    }

    public Reader getCopy() throws IOException {
        return new StringReader(this.getCopyAsString());
    }

    public synchronized String getCopyAsString() throws IOException {
        if (this._isUntouched) {
            this.copyReader();
        }
        return this._buffer.toString();
    }

    private void copyReader() throws IOException {
        char[] c = new char[1024];
        int charsRead = this._reader.read(c, 0, 1024);
        this._buffer = new StringBuffer();
        while (charsRead > 0) {
            this._buffer.append(c, 0, charsRead);
            charsRead = this._reader.read(c, 0, 1024);
        }
        this._reader.close();
        this._isClosed = true;
        this._isUntouched = false;
        this.reopen();
    }

    public void close() throws IOException {
        this._reader.close();
        this._isClosed = true;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this._isUntouched) {
            this.copyReader();
        }
        return this._reader.read(cbuf, off, len);
    }
}

