/*
 * Decompiled with CFR 0.152.
 */
package soapical.util;

import java.util.StringTokenizer;

class EncodingDetector {
    String _name;
    int[] _magic;
    public static final int MIN_OCTETS_NEEDED = 4;

    public EncodingDetector(String magic, String name) {
        StringTokenizer tokenizer = new StringTokenizer(magic, " ");
        int size = tokenizer.countTokens();
        this._name = name;
        this._magic = new int[size];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            this._magic[i] = Integer.parseInt(next, 16);
            ++i;
        }
    }

    public String name() {
        return this._name;
    }

    public boolean matches(byte[] prolog) {
        int min = prolog.length > this._magic.length ? this._magic.length : prolog.length;
        int j = 0;
        while (j < min) {
            if (prolog[j] != this._magic[j]) {
                return false;
            }
            ++j;
        }
        return true;
    }
}

