/*
 * Decompiled with CFR 0.152.
 */
package soapical.likeoldsax;

import com.megginson.sax.XMLWriter;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import soapical.likeoldsax.NamespaceIron;

public class SpecificXMLWriter
implements ContentHandler {
    private final Attributes EMPTY_ATTS = new AttributesImpl();
    private final String EMPTY_STRING = "";
    private ContentHandler _handler;
    private String _namespaceURI;
    private String _prefix;
    private boolean _hasPrefix;

    public SpecificXMLWriter(ContentHandler handler, String namespaceURI, String prefix) {
        this._hasPrefix = prefix != null && prefix.length() > 0;
        this._namespaceURI = namespaceURI;
        this._prefix = prefix;
        this._handler = handler;
        if ((namespaceURI == null || namespaceURI.length() == 0) && this._hasPrefix) {
            String error = "You can't have both a nonempty prefix and an empty namespaceURI";
            throw new IllegalArgumentException(error);
        }
        if (this._handler == null) {
            String error = "You tried to construct me with a null ContentHandler";
            throw new IllegalArgumentException(error);
        }
    }

    public SpecificXMLWriter(Writer writer, String namespaceURI, String prefix) {
        this((ContentHandler)new XMLWriter(writer), namespaceURI, prefix);
    }

    public void startDocument() throws SAXException {
        this._handler.startDocument();
    }

    public void endDocument() throws SAXException {
        this._handler.endDocument();
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this._handler.startElement(uri, localName, qName, atts);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this._handler.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        this._handler.characters(ch, start, len);
    }

    public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
        this._handler.ignorableWhitespace(ch, start, len);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this._handler.processingInstruction(target, data);
    }

    public void setDocumentLocator(Locator locator) {
        this._handler.setDocumentLocator(locator);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this._handler.endPrefixMapping(prefix);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this._handler.startPrefixMapping(prefix, uri);
    }

    public void skippedEntity(String name) throws SAXException {
        this._handler.skippedEntity(name);
    }

    public void startElement(String localName) throws SAXException {
        this.startElement(localName, this.EMPTY_ATTS);
    }

    public void startElement(String localName, Attributes atts) throws SAXException {
        this.startElement(this._namespaceURI, localName, this.toQName(localName), atts);
    }

    public void emptyElement(String localName) throws SAXException {
        this.emptyElement(localName, this.EMPTY_ATTS);
    }

    public void emptyElement(String localName, Attributes atts) throws SAXException {
        this.startElement(localName, atts);
        this.endElement(localName);
    }

    public void endElement(String localName) throws SAXException {
        this.endElement(this._namespaceURI, localName, this.toQName(localName));
    }

    public void addAttribute(AttributesImpl attrs, String localName, String type, String value) throws SAXException {
        attrs.addAttribute("", localName, localName, type, value);
    }

    private String toQName(String localName) {
        if (NamespaceIron.isQName(localName)) {
            String error = "'localName' should not be qualified";
            throw new IllegalArgumentException(error);
        }
        return NamespaceIron.toQName(this._prefix, localName);
    }
}

