/*
 * Decompiled with CFR 0.152.
 */
package soapical.likeoldsax;

import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;
import soapical.likeoldsax.FriendlyNamespaceSupport;
import soapical.likeoldsax.LikeOldSAXConstants;
import soapical.likeoldsax.NamespaceIron;

public class DocumentHandlerWrapper
implements ContentHandler,
LikeOldSAXConstants {
    private DocumentHandler _handler;
    private FriendlyNamespaceSupport _namespaces;
    private FriendlyNamespaceSupport _oldNamespaces;

    public DocumentHandlerWrapper(DocumentHandler handler) {
        this._handler = handler;
        this._namespaces = new FriendlyNamespaceSupport();
        this._oldNamespaces = new FriendlyNamespaceSupport();
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this._namespaces.pushContext();
        String prefix = this._namespaces.declareNamespaces(uri, localName, qName);
        List attPrefixes = this._namespaces.declareNamespaces(atts);
        int attLen = atts.getLength();
        AttributeListImpl attList = new AttributeListImpl();
        int i = 0;
        while (i < attLen) {
            attList.addAttribute(atts.getQName(i), atts.getType(i), atts.getValue(i));
            ++i;
        }
        this.addNewPrefixes(prefix, attList);
        this.addNewPrefixes(attPrefixes, attList);
        this._oldNamespaces.pushContext();
        this._oldNamespaces.declareNamespaces(uri, localName, qName);
        this._oldNamespaces.declareNamespaces(atts);
        this._handler.startElement(qName, attList);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this._oldNamespaces.popContext();
        this._namespaces.popContext();
        this._handler.endElement(qName);
    }

    public void startDocument() throws SAXException {
        this._handler.startDocument();
    }

    public void endDocument() throws SAXException {
        this._handler.endDocument();
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        this._handler.characters(ch, start, len);
    }

    public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
        this._handler.ignorableWhitespace(ch, start, len);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this._handler.processingInstruction(target, data);
    }

    public void setDocumentLocator(Locator locator) {
        this._handler.setDocumentLocator(locator);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    private void addNewPrefixes(String prefix, AttributeListImpl atts) {
        String newURI = this._namespaces.getURI(prefix);
        String oldURI = this._oldNamespaces.getURI(prefix);
        if (newURI == null) {
            String error = "new prefix " + prefix + " was undeclared...";
            throw new IllegalArgumentException(error);
        }
        if (atts == null) {
            throw new IllegalArgumentException("null attributes");
        }
        if (oldURI == null || !oldURI.equals(newURI)) {
            String attrName = prefix == null || "".equals(prefix) ? "xmlns" : NamespaceIron.toQName("xmlns", prefix);
            atts.addAttribute(attrName, "CDATA", newURI);
        }
    }

    private void addNewPrefixes(List prefixes, AttributeListImpl atts) {
        for (Object next : prefixes) {
            if (!(next instanceof String)) {
                String error = prefixes + " is not a list of String";
                throw new IllegalArgumentException(error);
            }
            this.addNewPrefixes((String)next, atts);
        }
    }
}

