/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.xog;

import com.dd.sources.Source;
import com.dd.xog.saaj.configuration.Configuration;
import com.dd.xog.saaj.worker.WorkTask;
import com.dd.xog.saaj.xog.XOGSoapClient;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;

public class Xogger
implements WorkTask {
    private static Logger log = Logger.getLogger(Xogger.class);
    Configuration config = null;
    public static final int DO_XOG_1_SOURCE = 0;
    public static final int DO_XOG_1_FILE = 1;
    public static final int DO_LOGIN = 2;
    public static final int DO_LOGOUT = 3;
    public static final int DO_XOG_FILES = 4;
    XOGSoapClient client = null;

    public Xogger(Configuration config) {
        this.config = config;
    }

    public SOAPMessage doLogin() throws Exception {
        String url = this.config.getXOGSettings().getUrl();
        url.startsWith("https");
        this.client = new XOGSoapClient(this.config.getXOGSettings(), this.config.getProxy());
        SOAPMessage loginResponse = this.client.login(this.config.getXOGSettings().getUserid(), this.config.getXOGSettings().getPassword());
        return loginResponse;
    }

    public SOAPMessage doLogout() throws Exception {
        if (this.client != null) {
            SOAPMessage logoutResponse = this.client.logout();
            return logoutResponse;
        }
        return null;
    }

    public SOAPMessage doXOG1(File file) throws Exception {
        try {
            SOAPMessage readResponse;
            SOAPMessage loginResponse = this.doLogin();
            if (this.client.getSessionId() == null) {
                SOAPMessage sOAPMessage = loginResponse;
                return sOAPMessage;
            }
            SOAPMessage sOAPMessage = readResponse = this.client.doRequest(file);
            return sOAPMessage;
        }
        finally {
            this.doLogout();
        }
    }

    public SOAPMessage doXOG(File file) throws Exception {
        SOAPMessage readResponse = this.client.doRequest(file);
        return readResponse;
    }

    public SOAPMessage doXOG1(Source source) throws Exception {
        try {
            SOAPMessage readResponse;
            SOAPMessage loginResponse = this.doLogin();
            if (this.client.getSessionId() == null) {
                SOAPMessage sOAPMessage = loginResponse;
                return sOAPMessage;
            }
            SOAPMessage sOAPMessage = readResponse = this.client.doRequest(source.getContents());
            return sOAPMessage;
        }
        finally {
            this.doLogout();
        }
    }

    private void testConnection(String url) throws IOException {
        int read;
        log.debug((Object)("testConnection " + url));
        URL connUrl = new URL(url);
        URLConnection connect = connUrl.openConnection();
        connect.setConnectTimeout(6000);
        connect.setReadTimeout(6000);
        log.debug((Object)("timeout " + connect.getConnectTimeout()));
        InputStream stream = connect.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((read = stream.read(buffer)) > -1) {
            baos.write(buffer, 0, read);
        }
        stream.close();
        log.debug((Object)("response " + new String(buffer)));
        log.debug((Object)("end readURL " + url));
    }

    @Override
    public Object doWork(int what, Object[] args) throws Exception {
        switch (what) {
            case 0: {
                return this.doXOG1((Source)args[0]);
            }
            case 1: {
                return this.doXOG1((File)args[0]);
            }
            case 2: {
                return this.doLogin();
            }
            case 3: {
                return this.doLogout();
            }
            case 4: {
                return this.doXOG((File)args[0]);
            }
        }
        throw new Exception("Unknown work");
    }

    public XOGSoapClient getClient() {
        return this.client;
    }

    public void setClient(XOGSoapClient client) {
        this.client = client;
    }
}

