/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.xog;

import com.dd.xog.saaj.ClarityPlugIn;
import com.dd.xog.saaj.configuration.Configuration;
import com.dd.xog.saaj.xog.Proxy;
import com.dd.xog.saaj.xog.XMLUtils;
import com.dd.xog.saaj.xog.XOGSettings;
import com.dd.xog.saaj.xog.XOGresult;
import java.io.File;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis.AxisProperties;
import org.apache.axis.soap.SOAPConnectionImpl;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import soapical.util.Soapkit;

public class XOGSoapClient {
    SOAPConnection conn = null;
    String sessionId = null;
    Transformer tf = null;
    MessageFactory mf = null;
    StreamResult result = null;
    XOGSettings settings = null;
    Proxy proxy = null;
    private static Logger log = Logger.getLogger(XOGSoapClient.class);

    public XOGSoapClient(XOGSettings settings, Proxy proxy) throws TransformerConfigurationException, UnsupportedOperationException, SOAPException {
        this.settings = settings;
        this.proxy = proxy;
        this.setProperties();
        SOAPConnectionFactory scf = SOAPConnectionFactory.newInstance();
        this.conn = scf.createConnection();
        if (this.conn instanceof SOAPConnectionImpl) {
            SOAPConnectionImpl soapConn = (SOAPConnectionImpl)this.conn;
            log.info((Object)"setting timeout to 0");
            soapConn.setTimeout(Integer.valueOf(0));
        }
        TransformerFactory tff = TransformerFactory.newInstance();
        this.tf = tff.newTransformer();
        this.tf.setOutputProperty("indent", "yes");
        this.result = new StreamResult(System.out);
    }

    public void setProperties() {
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        System.setProperty("javax.xml.soap.SOAPFactory", "org.apache.axis.soap.SOAPFactoryImpl");
        System.setProperty("javax.xml.soap.MessageFactory", "org.apache.axis.soap.MessageFactoryImpl");
        System.setProperty("javax.xml.soap.SOAPConnectionFactory", "org.apache.axis.soap.SOAPConnectionFactoryImpl");
        if (this.proxy != null && this.settings.isUseProxy()) {
            log.debug((Object)"service is using Axis proxy");
            AxisProperties.setProperty((String)"http.proxyHost", (String)this.proxy.getHost());
            AxisProperties.setProperty((String)"http.proxyUser", (String)this.proxy.getUser());
            AxisProperties.setProperty((String)"http.proxyPassword", (String)this.proxy.getPassword());
            AxisProperties.setProperty((String)"http.proxyPort", (String)String.valueOf(this.proxy.getPort()));
        } else {
            log.debug((Object)"service is not using Axis proxy");
            AxisProperties.setProperty((String)"http.proxyHost", (String)"");
            AxisProperties.setProperty((String)"http.proxyPort", (String)"");
        }
    }

    public SOAPMessage callWebService(String content) throws Exception {
        this.mf = MessageFactory.newInstance();
        SOAPMessage requestMsg = this.mf.createMessage();
        this.createEnvelope(requestMsg);
        SOAPPart sp = requestMsg.getSOAPPart();
        SOAPEnvelope env = sp.getEnvelope();
        SOAPHeader hd = env.getHeader();
        SOAPBody bd = env.getBody();
        SOAPElement se = Soapkit.toSOAPElement((Reader)new StringReader(content));
        bd.addChildElement(se);
        requestMsg.saveChanges();
        System.out.println("\n Soap request:\n");
        requestMsg.writeTo((OutputStream)System.out);
        return this.conn.call(requestMsg, (Object)this.settings.getUrl());
    }

    public SOAPMessage login(String user, String password) throws Exception {
        log.debug((Object)"SOAP Login to Clarity");
        this.mf = MessageFactory.newInstance();
        SOAPMessage loginMsg = this.mf.createMessage();
        this.createEnvelope(loginMsg);
        SOAPPart sp = loginMsg.getSOAPPart();
        SOAPEnvelope env = sp.getEnvelope();
        SOAPBody bd = env.getBody();
        SOAPElement be = bd.addChildElement(env.createName("Login", "", "http://www.niku.com/xog"));
        be.addChildElement("Username").addTextNode(user);
        be.addChildElement("Password").addTextNode(password);
        loginMsg.saveChanges();
        System.out.println("\n Soap login request:\n");
        loginMsg.writeTo((OutputStream)System.out);
        System.out.println();
        SOAPMessage loginResponse = this.conn.call(loginMsg, (Object)this.settings.getUrl());
        this.logSoapResponse(loginResponse);
        NodeList nodeList = loginResponse.getSOAPPart().getElementsByTagNameNS("http://www.niku.com/xog", "SessionID");
        if (nodeList.getLength() == 1) {
            this.sessionId = XMLUtils.getNodeContent(nodeList.item(0));
            System.out.println("session id = " + this.sessionId);
        }
        return loginResponse;
    }

    public SOAPMessage doRequest(File xmlFile) throws Exception {
        Document doc = XMLUtils.parseFile(xmlFile);
        return this.doRequest(doc);
    }

    public SOAPMessage doRequest(Document doc) throws Exception {
        SOAPMessage requestMsg = this.mf.createMessage();
        this.createEnvelope(requestMsg);
        SOAPPart sp = requestMsg.getSOAPPart();
        SOAPEnvelope env = sp.getEnvelope();
        SOAPBody bd = env.getBody();
        SOAPBodyElement bodyElement = bd.addDocument(doc);
        return this.doRequest((SOAPElement)bodyElement);
    }

    public SOAPMessage doRequest(String xml) throws Exception {
        return this.doRequest(new StringReader(xml));
    }

    public SOAPMessage doRequest(Reader reader) throws Exception {
        SOAPElement se = Soapkit.toSOAPElement((Reader)reader);
        return this.doRequest(se);
    }

    public SOAPMessage doRequest(SOAPElement content) throws Exception {
        SOAPBody bd;
        log.debug((Object)"SOAP doRequest to Clarity");
        SOAPMessage requestMsg = this.mf.createMessage();
        this.createEnvelope(requestMsg);
        SOAPPart sp = requestMsg.getSOAPPart();
        SOAPEnvelope env = sp.getEnvelope();
        SOAPHeader hd = env.getHeader();
        SOAPElement auth = hd.addChildElement(env.createName("Auth", "xog", "http://www.niku.com/xog"));
        auth.addChildElement("SessionID").addTextNode(this.sessionId);
        SOAPBody be = bd = env.getBody();
        try {
            String method = XMLUtils.getMethod((Node)content);
            System.out.println("Constructed operation " + method + " from Action and or objectType in Header");
            System.out.println("Adding <" + method + ">" + " to soapBody");
            be = bd.addChildElement(env.createName(method, "xog", "http://www.niku.com/xog"));
        }
        catch (Exception e) {
            System.out.println("Action and or objectType attributes not found ");
            System.out.println("Assuming that xml contains XOG operation as first element");
        }
        be.addChildElement(content);
        requestMsg.saveChanges();
        return this.conn.call(requestMsg, (Object)this.settings.getUrl());
    }

    public SOAPMessage logout() throws Exception {
        log.debug((Object)"SOAP Logout from Clarity");
        SOAPMessage logoutResponse = null;
        if (this.sessionId != null) {
            SOAPMessage logoutMsg = this.mf.createMessage();
            this.createEnvelope(logoutMsg);
            SOAPPart sp = logoutMsg.getSOAPPart();
            SOAPEnvelope env = sp.getEnvelope();
            SOAPBody bd = env.getBody();
            SOAPElement be = bd.addChildElement(env.createName("Logout", "", "http://www.niku.com/xog"));
            be.addChildElement("SessionID").addTextNode(this.sessionId);
            logoutMsg.saveChanges();
            logoutResponse = this.conn.call(logoutMsg, (Object)this.settings.getUrl());
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
        }
        return logoutResponse;
    }

    public void createEnvelope(SOAPMessage msg) throws Exception {
        SOAPPart sp = msg.getSOAPPart();
        SOAPEnvelope env = sp.getEnvelope();
        env.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        env.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        env.addNamespaceDeclaration("enc", "http://schemas.xmlsoap.org/soap/encoding/");
        env.addNamespaceDeclaration("env", "http://schemas.xmlsoap.org/soap/envelop/");
        env.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
    }

    private void logSoapResponse(SOAPMessage msg) throws Exception {
        if (msg.getSOAPPart().getContent() != null) {
            this.tf.transform(msg.getSOAPPart().getContent(), this.result);
        } else {
            System.out.println("Soap reponse has no content");
            this.tf.transform(new DOMSource((Node)msg.getSOAPPart()), this.result);
        }
        System.out.println();
    }

    private void logSoapResponse(Node n) throws Exception {
        this.tf.transform(new DOMSource(n), this.result);
        System.out.println();
    }

    private static int convertToInteger(String s) {
        if (s == null) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public static XOGresult getXOGresult(Node n) throws Exception {
        XOGresult xogResult = new XOGresult();
        if (n != null) {
            if (n.getLocalName().equals("NikuDataBus")) {
                xogResult.setState(XMLUtils.getNodeValue(n, "XOGOutput/Status/@state", false));
                xogResult.setFailureRecords(XOGSoapClient.convertToInteger(XMLUtils.getNodeValue(n, "XOGOutput/Statistics/@failureRecords", false)));
                xogResult.setInsertedRecords(XOGSoapClient.convertToInteger(XMLUtils.getNodeValue(n, "XOGOutput/Statistics/@insertedRecords", false)));
                xogResult.setUpdatedRecords(XOGSoapClient.convertToInteger(XMLUtils.getNodeValue(n, "XOGOutput/Statistics/@updatedRecords", false)));
                xogResult.findAndSetHighestSeverity(XMLUtils.getNodeValues(n, "XOGOutput//Severity/text()"));
            } else {
                xogResult.setState(XMLUtils.getNodeValue(n, "Status/@state", false));
                xogResult.setFailureRecords(XOGSoapClient.convertToInteger(XMLUtils.getNodeValue(n, "Statistics/@failureRecords", false)));
                xogResult.setInsertedRecords(XOGSoapClient.convertToInteger(XMLUtils.getNodeValue(n, "Statistics/@insertedRecords", false)));
                xogResult.setUpdatedRecords(XOGSoapClient.convertToInteger(XMLUtils.getNodeValue(n, "Statistics/@updatedRecords", false)));
                xogResult.findAndSetHighestSeverity(XMLUtils.getNodeValues(n, ".//Severity/text()"));
            }
        }
        return xogResult;
    }

    public static XOGresult getXOGresult(Document doc) throws Exception {
        log.debug((Object)"getXOGresult");
        return XOGSoapClient.getXOGresult(doc.getDocumentElement());
    }

    public static XOGresult getXOGresult(SOAPMessage readResponse) throws Exception {
        log.debug((Object)"getXOGresult");
        XOGresult xogResult = new XOGresult();
        Iterator it = readResponse.getSOAPBody().getChildElements();
        if (it.hasNext()) {
            Node n = (Node)it.next();
            return XOGSoapClient.getXOGresult(n);
        }
        return xogResult;
    }

    private static String getContentAsStringOld(SOAPMessage msg, boolean format) throws Exception {
        Element n = XMLUtils.getHighestChildElement((Node)msg.getSOAPBody());
        if (n == null) {
            n = XMLUtils.getHighestChildElement((Node)msg.getSOAPPart());
        }
        if (n != null) {
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory tff = TransformerFactory.newInstance();
            Transformer tf = tff.newTransformer();
            if (format) {
                tf.setOutputProperty("indent", "yes");
                tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "1");
            }
            tf.transform(new DOMSource(n), result);
            return stringWriter.getBuffer().toString();
        }
        return null;
    }

    private static String getContentAsString(SOAPMessage msg, boolean format) throws Exception {
        log.debug((Object)"getContentAsString");
        Source source = msg.getSOAPPart().getContent();
        Node root = null;
        if (source instanceof DOMSource) {
            root = ((DOMSource)source).getNode();
        } else if (source instanceof SAXSource) {
            InputSource inSource = ((SAXSource)source).getInputSource();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = null;
            db = dbf.newDocumentBuilder();
            Document doc = db.parse(inSource);
            root = doc.getDocumentElement();
        }
        if (root == null) {
            throw new Exception("Coud create root element from soapmessage");
        }
        Element envelope = XMLUtils.getFirstElementWithTagname(root, "Envelope");
        if (envelope == null) {
            throw new Exception("Coud create Envelope  from soapmessage");
        }
        Element body = XMLUtils.getFirstElementWithTagname(envelope, "Body");
        if (body == null) {
            throw new Exception("Coud create Envelope  from soapmessage");
        }
        Element n = XMLUtils.getHighestChildElement(body);
        if (n == null) {
            n = envelope;
        }
        if (n != null) {
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory tff = TransformerFactory.newInstance();
            Transformer tf = tff.newTransformer();
            if (format) {
                tf.setOutputProperty("indent", "yes");
                tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "1");
            }
            tf.transform(new DOMSource(n), result);
            return stringWriter.getBuffer().toString();
        }
        return "";
    }

    private static String getContentToString(SOAPMessage msg, boolean format) throws Exception {
        log.debug((Object)"getContentToString");
        log.debug((Object)("msg SOAPMessage implementation " + msg.getClass()));
        Element n = XMLUtils.getHighestChildElement((Node)msg.getSOAPBody());
        if (n == null) {
            n = XMLUtils.getHighestChildElement((Node)msg.getSOAPPart());
        }
        if (n != null) {
            return n.toString();
        }
        return "";
    }

    public static String getContent(SOAPMessage msg, boolean format) throws Exception {
        if (ClarityPlugIn.SHOW_UNICODE_CHARACTERS) {
            return XOGSoapClient.getContentToString(msg, format);
        }
        return XOGSoapClient.getContentAsString(msg, format);
    }

    public static void main(String[] args) {
        XOGSoapClient client = null;
        try {
            try {
                Configuration aConfiguration = new Configuration(new File(args[0]));
                String xmlFile = args[1];
                client = new XOGSoapClient(aConfiguration.getXOGSettings(), aConfiguration.getProxy());
                String user = aConfiguration.getXOGSettings().getUserid();
                String pw = aConfiguration.getXOGSettings().getPassword();
                SOAPMessage loginResponse = client.login(user, pw);
                client.logSoapResponse(loginResponse);
                long start = System.currentTimeMillis();
                SOAPMessage readResponse = client.doRequest(new File(xmlFile));
                StringBuilder sbXml = new StringBuilder();
                sbXml.append("<NikuDataBus xmlns=\"\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"../xsd/nikuxog_read.xsd\">");
                sbXml.append("\n<Header action=\"read\" externalSource=\"NIKU\" objectType=\"user\" version=\"6.0.11\"/>");
                sbXml.append("\n<Query>");
                sbXml.append("\n<Filter criteria=\"EQUALS\" name=\"userName\">PW78DS</Filter>");
                sbXml.append("\n</Query>");
                sbXml.append("\n</NikuDataBus>");
                long end = System.currentTimeMillis();
                log.debug((Object)("responsetime " + (end - start) / 1000L + " sec"));
                XOGresult result = XOGSoapClient.getXOGresult(readResponse);
                System.out.println("result " + result);
                Element n = XMLUtils.getHighestChildElement((Node)readResponse.getSOAPBody());
                if (n != null) {
                    client.logSoapResponse(n);
                }
                System.out.println("program ended");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    SOAPMessage logoutResponse = client.logout();
                    client.logSoapResponse(logoutResponse);
                }
                catch (Exception e2) {
                    System.out.println(e2.getMessage());
                }
            }
        }
        finally {
            try {
                SOAPMessage logoutResponse = client.logout();
                client.logSoapResponse(logoutResponse);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }
}

