/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.xog;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static Logger log = Logger.getLogger(XMLUtils.class);

    public static Document parseFile(File file) throws Exception {
        Document doc;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            doc = factory.newDocumentBuilder().parse(file);
        }
        catch (SAXException e) {
            throw new Exception("Error while parsing the file " + file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new Exception("The file " + file.getAbsolutePath() + " can't be processed");
        }
        catch (ParserConfigurationException e) {
            throw new Exception("Error while parsing the file " + file.getAbsolutePath() + ":" + e.getMessage());
        }
        return doc;
    }

    public static Document parse(String xml) throws Exception {
        return XMLUtils.parse(new StringReader(xml));
    }

    public static Document parse(Reader reader) throws Exception {
        Document doc;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            doc = factory.newDocumentBuilder().parse(new InputSource(reader));
        }
        catch (SAXException e) {
            log.error((Object)"SAXException while parsing the xml", (Throwable)e);
            throw new Exception("Error while parsing the xml" + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"ParserConfigurationException while parsing the xml", (Throwable)e);
            throw new Exception("Error while parsing the xml" + e.getMessage());
        }
        return doc;
    }

    public static String getNodeContent(Node node) {
        StringBuffer sb = new StringBuffer();
        switch (node.getNodeType()) {
            case 1: {
                boolean mixed = false;
                NodeList nodeList = node.getChildNodes();
                int i = 0;
                while (i < nodeList.getLength()) {
                    if (nodeList.item(i).getNodeType() == 3) {
                        sb.append(nodeList.item(i).getNodeValue());
                    } else {
                        mixed = true;
                    }
                    ++i;
                }
                if (sb.toString().trim().length() != 0 || !mixed) break;
                sb.setLength(0);
                break;
            }
            case 2: {
                sb.append(node.getNodeValue());
                break;
            }
            case 8: {
                sb.append(node.getNodeValue());
                break;
            }
            case 3: {
                sb.append(node.getNodeValue());
                break;
            }
            case 4: {
                sb.append(node.getNodeValue());
                break;
            }
            case 7: {
                sb.append(node.getNodeValue());
                break;
            }
            case 9: {
                sb.append("");
                break;
            }
            case 5: {
                NodeList erNodeList = node.getChildNodes();
                int i = 0;
                while (i < erNodeList.getLength()) {
                    if (erNodeList.item(i).getNodeType() == 3) {
                        sb.append(erNodeList.item(i).getNodeValue());
                    }
                    ++i;
                }
                break;
            }
            default: {
                sb.append(node.getNodeValue());
            }
        }
        return sb.toString();
    }

    public static Element getFirstElementWithTagname(Node n, String name) {
        NodeList list = n.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Element el;
            if (list.item(i).getNodeType() == 1 && (el = (Element)list.item(i)).getNodeName().endsWith(name)) {
                return el;
            }
            ++i;
        }
        return null;
    }

    public static String getMethod(Node node) throws Exception {
        String action = XMLUtils.getNodeValue(node, "Header/@action", true);
        String object = XMLUtils.getNodeValue(node, "Header/@objectType", true);
        return String.valueOf(action.substring(0, 1).toUpperCase()) + action.substring(1) + object.substring(0, 1).toUpperCase() + object.substring(1);
    }

    public static Element getHighestChildElement(Node node) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        NodeList nodes = (NodeList)xPath.evaluate("*", node, XPathConstants.NODESET);
        if (nodes != null) {
            if (nodes.getLength() == 1) {
                return (Element)nodes.item(0);
            }
            if (nodes.getLength() > 1) {
                return (Element)node;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getNodeValue(Node node, String xpath, boolean required) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        NodeList nodes = (NodeList)xPath.evaluate(xpath, node, XPathConstants.NODESET);
        if (nodes != null && nodes.getLength() == 1) {
            Node n = nodes.item(0);
            String value = n.getNodeValue();
            if (value != null && value.length() != 0) {
                return value;
            }
            if (required) {
                throw new Exception("Invalid value for " + xpath);
            }
            log.error((Object)("Invalid value for " + xpath));
            return null;
        }
        if (required) {
            throw new Exception("No result from  xpath " + xpath);
        }
        log.error((Object)("No result from  xpath " + xpath));
        return null;
    }

    public static String[] getNodeValues(Node node, String xpath) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        NodeList nodes = (NodeList)xPath.evaluate(xpath, node, XPathConstants.NODESET);
        if (nodes == null) {
            return new String[0];
        }
        String[] values = new String[nodes.getLength()];
        int i = 0;
        while (i < nodes.getLength()) {
            String value;
            Node n = nodes.item(i);
            values[i] = value = n.getNodeValue();
            ++i;
        }
        return values;
    }
}

