/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.xog;

import com.dd.xog.saaj.resources.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WaitDialog
extends JDialog {
    JButton jStop;
    boolean taskOver = false;
    Throwable throwable;
    JLabel lbText;

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable t) {
        this.throwable = t;
    }

    public static WaitDialog createWaitDialog(Component arg0, String arg1, boolean arg2, String text) {
        Window parent = WaitDialog.findComponentOwner(arg0);
        if (parent == null) {
            Frame nullFrame = null;
            return new WaitDialog(nullFrame, arg1, arg2, text);
        }
        if (parent instanceof Frame) {
            return new WaitDialog((Frame)parent, arg1, arg2, text);
        }
        return new WaitDialog((Dialog)parent, arg1, arg2, text);
    }

    public WaitDialog(Dialog arg0, String arg1, boolean arg2, String text) {
        super(arg0, arg1, arg2);
        this.construct(text);
    }

    public WaitDialog(Frame arg0, String arg1, boolean arg2, String text) {
        super(arg0, arg1, arg2);
        this.construct(text);
    }

    public void construct(String text) {
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 2));
        top.setBackground(Color.WHITE);
        top.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.lbText = new JLabel(text);
        top.add(this.lbText);
        top.add(Box.createRigidArea(new Dimension(10, 0)));
        ImageIcon icon = new ImageIcon(ResourceLoader.class.getResource("wait24.gif"));
        JLabel wheelLabel = new JLabel(icon);
        top.add(wheelLabel);
        JPanel bottom = new JPanel();
        bottom.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        bottom.setLayout(new FlowLayout());
        this.jStop = new JButton("Cancel");
        bottom.add(this.jStop);
        this.getContentPane().add((Component)top, "Center");
        this.getContentPane().add((Component)bottom, "Last");
        this.setSize(500, 150);
        this.showCentered();
        this.setResizable(false);
    }

    public void showCentered() {
        Window parent = (Window)this.getParent();
        if (parent == null) {
            return;
        }
        if (!parent.isShowing()) {
            return;
        }
        Dimension dim = parent.getSize();
        Point loc = parent.getLocationOnScreen();
        Dimension size = this.getSize();
        loc.x += (dim.width - size.width) / 2;
        loc.y += (dim.height - size.height) / 2;
        if (loc.x < 0) {
            loc.x = 0;
        }
        if (loc.y < 0) {
            loc.y = 0;
        }
        Dimension screen = this.getToolkit().getScreenSize();
        if (size.width > screen.width) {
            size.width = screen.width;
        }
        if (size.height > screen.height) {
            size.height = screen.height;
        }
        if (loc.x + size.width > screen.width) {
            loc.x = screen.width - size.width;
        }
        if (loc.y + size.height > screen.height) {
            loc.y = screen.height - size.height;
        }
        this.setBounds(loc.x, loc.y, size.width, size.height);
    }

    public static Window findComponentOwner(Component comp) {
        if (comp == null) {
            return null;
        }
        if (comp instanceof Frame || comp instanceof Dialog) {
            return (Window)comp;
        }
        return WaitDialog.findComponentOwner(comp.getParent());
    }

    public void addCancelActionListener(ActionListener listener) {
        this.jStop.addActionListener(listener);
    }

    public void removeCancelActionListener(ActionListener listener) {
        this.jStop.removeActionListener(listener);
    }

    public static void main(String[] args) {
        WaitDialog sample = WaitDialog.createWaitDialog(null, "Sample Dialog", true, "Connecting");
        sample.setVisible(true);
    }

    public boolean isTaskOver() {
        return this.taskOver;
    }

    public void setTaskOver(boolean taskOver) {
        this.taskOver = taskOver;
    }

    public void setMessage(String text) {
        this.lbText.setText(text);
    }
}

