/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.worker;

import com.dd.xog.saaj.table.XogResultsTableModel;
import com.dd.xog.saaj.xog.XMLUtils;
import com.dd.xog.saaj.xog.XOGSoapClient;
import com.dd.xog.saaj.xog.XOGresult;
import java.io.File;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class XogResultMultiThreadWorker
extends SwingWorker<Integer, String> {
    private static Logger log = Logger.getLogger(XogResultMultiThreadWorker.class);
    private int nextRow = -1;
    private final JTextArea messagesTextArea;
    private final JTable progressTable;
    private int threadCount = 1;

    private static void failIfInterrupted() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Interrupted while getting Xog results");
        }
    }

    public XogResultMultiThreadWorker(int threadCount, JTextArea messagesTextArea, JTable progressTable) {
        this.threadCount = threadCount;
        this.messagesTextArea = messagesTextArea;
        this.progressTable = progressTable;
    }

    @Override
    protected Integer doInBackground() throws Exception {
        ExecutorService exe = Executors.newFixedThreadPool(this.threadCount);
        XogResultsTableModel xogTableModel = (XogResultsTableModel)this.progressTable.getModel();
        CountDownLatch latch = new CountDownLatch(this.threadCount);
        try {
            XogResultMultiThreadWorker.failIfInterrupted();
            this.publish("Number of possible xog result files: " + xogTableModel.getRowCount() + " \n");
            int i = 0;
            while (i < this.threadCount) {
                XogResultMultiThreadWorker.failIfInterrupted();
                ExampleBatchTask batch = new ExampleBatchTask(this.messagesTextArea, latch, xogTableModel, i);
                exe.execute(batch);
                ++i;
            }
            latch.await();
            return 0;
        }
        catch (InterruptedException e) {
            System.out.println("SwingWorker backgound task is interrupted");
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            System.out.println("return from swingworker task");
            this.firePropertyChange("statex", "", "returning");
        }
    }

    private synchronized int getNextRow() {
        if (this.isCancelled()) {
            return -1;
        }
        XogResultsTableModel xogTableModel = (XogResultsTableModel)this.progressTable.getModel();
        int size = xogTableModel.getRowCount();
        while (this.nextRow + 1 < size) {
            this.setProgress((++this.nextRow + 1) * 100 / size);
            if (!xogTableModel.getXogTable().get(this.nextRow).isSelected()) continue;
            return this.nextRow;
        }
        return -1;
    }

    @Override
    protected void process(List<String> chunks) {
        for (String string : chunks) {
            this.messagesTextArea.append(string);
            this.messagesTextArea.append("\n");
        }
    }

    class ExampleBatchTask
    implements Runnable {
        JTextArea output;
        CountDownLatch latch;
        int threadNr = 0;
        XogResultsTableModel xogTableModel;

        public ExampleBatchTask(JTextArea output, CountDownLatch latch, XogResultsTableModel xogTableModel, int threadNr) {
            this.output = output;
            this.latch = latch;
            this.xogTableModel = xogTableModel;
            this.threadNr = threadNr;
        }

        @Override
        public void run() {
            Object xogger = null;
            try {
                try {
                    int row = 0;
                    while ((row = XogResultMultiThreadWorker.this.getNextRow()) > -1) {
                        File file = this.xogTableModel.getXogTable().get(row).getFInput();
                        this.xogTableModel.getXogTable().get(row).setStatus(10);
                        this.xogTableModel.getXogTable().get(row).setXogResult(null);
                        this.xogTableModel.getXogTable().get(row).setFOutput(null);
                        this.xogTableModel.fireTableRowsUpdated(row, row);
                        try {
                            try {
                                XogResultMultiThreadWorker.this.publish(new String[]{"[Thread-" + this.threadNr + "]: " + "processing file: " + file});
                                Document doc = XMLUtils.parseFile(file);
                                if (doc != null) {
                                    XOGresult result = XOGSoapClient.getXOGresult(doc);
                                    this.xogTableModel.getXogTable().get(row).setStatus(result.getOverallStatusIndication());
                                    this.xogTableModel.getXogTable().get(row).setXogResult(result);
                                    this.xogTableModel.fireTableRowsUpdated(row, row);
                                }
                            }
                            catch (Throwable t) {
                                this.xogTableModel.setValueAt(new Integer(2), row, 1);
                                XogResultMultiThreadWorker.this.publish(new String[]{"[Thread-" + this.threadNr + "]: " + "Fatal Error " + t.toString()});
                                this.xogTableModel.setValueAt(new Boolean(false), row, 0);
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            this.xogTableModel.setValueAt(new Boolean(false), row, 0);
                            throw throwable;
                        }
                        this.xogTableModel.setValueAt(new Boolean(false), row, 0);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (xogger != null) {
                        try {
                            XogResultMultiThreadWorker.this.publish(new String[]{"[Thread-" + this.threadNr + "]: " + "completed"});
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.latch.countDown();
                    return;
                }
            }
            catch (Throwable throwable) {
                if (xogger != null) {
                    try {
                        XogResultMultiThreadWorker.this.publish(new String[]{"[Thread-" + this.threadNr + "]: " + "completed"});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.latch.countDown();
                throw throwable;
            }
            if (xogger != null) {
                try {
                    XogResultMultiThreadWorker.this.publish(new String[]{"[Thread-" + this.threadNr + "]: " + "completed"});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.latch.countDown();
        }
    }
}

