/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.worker;

import com.dd.xog.saaj.configuration.Configuration;
import com.dd.xog.saaj.io.FileUtil;
import com.dd.xog.saaj.popup.XogPopupVO;
import com.dd.xog.saaj.table.XogTableModel;
import com.dd.xog.saaj.xog.XOGSoapClient;
import com.dd.xog.saaj.xog.Xogger;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class XogMultiThreadWorker
extends SwingWorker<Integer, String> {
    private static Logger log = Logger.getLogger(XogMultiThreadWorker.class);
    private int nextRow = -1;
    private final JTextArea messagesTextArea;
    private final JTable progressTable;
    private final XogPopupVO answer;
    private int threadCount = 1;

    private static void failIfInterrupted() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Interrupted while searching files");
        }
    }

    public XogMultiThreadWorker(XogPopupVO answer, int threadCount, JTextArea messagesTextArea, JTable progressTable) {
        this.answer = answer;
        this.threadCount = threadCount;
        this.messagesTextArea = messagesTextArea;
        this.progressTable = progressTable;
    }

    @Override
    protected Integer doInBackground() throws Exception {
        ExecutorService exe = Executors.newFixedThreadPool(this.threadCount);
        Configuration config = this.answer.getConfigurationList().getConfiguration(this.answer.getSelectedConfigurationIndex());
        XogTableModel xogTableModel = (XogTableModel)this.progressTable.getModel();
        CountDownLatch latch = new CountDownLatch(this.threadCount);
        try {
            int matches = 0;
            XogMultiThreadWorker.failIfInterrupted();
            this.publish("Found " + xogTableModel.getRowCount() + " xog files");
            int i = 0;
            while (i < this.threadCount) {
                XogMultiThreadWorker.failIfInterrupted();
                ExampleBatchTask batch = new ExampleBatchTask(config, this.messagesTextArea, latch, xogTableModel, i);
                exe.execute(batch);
                ++i;
            }
            latch.await();
            Integer n = matches;
            return n;
        }
        catch (InterruptedException e) {
            System.out.println("SwingWorker backgound task is interrupted");
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            System.out.println("return from swingworker task");
            this.firePropertyChange("statex", "", "returning");
        }
    }

    private synchronized int getNextRow() {
        if (this.isCancelled()) {
            return -1;
        }
        XogTableModel xogTableModel = (XogTableModel)this.progressTable.getModel();
        int size = xogTableModel.getRowCount();
        while (this.nextRow + 1 < size) {
            this.setProgress((++this.nextRow + 1) * 100 / size);
            if (!xogTableModel.getXogTable().get(this.nextRow).isSelected()) continue;
            return this.nextRow;
        }
        return -1;
    }

    @Override
    protected void process(List<String> chunks) {
        for (String string : chunks) {
            this.messagesTextArea.append(string);
            this.messagesTextArea.append("\n");
        }
    }

    static /* synthetic */ void access$1(XogMultiThreadWorker xogMultiThreadWorker, Object[] objectArray) {
        xogMultiThreadWorker.publish(objectArray);
    }

    static /* synthetic */ int access$2(XogMultiThreadWorker xogMultiThreadWorker) {
        return xogMultiThreadWorker.getNextRow();
    }

    static /* synthetic */ XogPopupVO access$3(XogMultiThreadWorker xogMultiThreadWorker) {
        return xogMultiThreadWorker.answer;
    }

    class ExampleBatchTask
    implements Runnable {
        JTextArea output;
        CountDownLatch latch;
        int threadNr = 0;
        XogTableModel xogTableModel;
        Configuration config;

        public ExampleBatchTask(Configuration config, JTextArea output, CountDownLatch latch, XogTableModel xogTableModel, int threadNr) {
            this.config = config;
            this.output = output;
            this.latch = latch;
            this.xogTableModel = xogTableModel;
            this.threadNr = threadNr;
        }

        private String addTimeExtension(String filename) {
            String suffix = "_" + this.getCurrentDate("yyyyMMdd_HHmmss");
            int indexExtension = filename.lastIndexOf(".");
            if (indexExtension < 0) {
                indexExtension = filename.length();
            }
            return String.valueOf(filename.substring(0, indexExtension)) + suffix + filename.substring(indexExtension);
        }

        private String getCurrentDate(String format) {
            String DATE_FORMAT = format;
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            return sdf.format(new Date());
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            xogger = null;
            try {
                try {
                    row = 0;
                    while ((row = XogMultiThreadWorker.access$2(XogMultiThreadWorker.this)) > -1) {
                        file = this.xogTableModel.getXogTable().get(row).getFInput();
                        this.xogTableModel.getXogTable().get(row).setStatus(10);
                        this.xogTableModel.getXogTable().get(row).setXogResult(null);
                        this.xogTableModel.getXogTable().get(row).setFOutput(null);
                        this.xogTableModel.fireTableRowsUpdated(row, row);
                        try {
                            block22: {
                                if (xogger != null) ** GOTO lbl28
                                xogger = new Xogger(this.config);
                                XogMultiThreadWorker.access$1(XogMultiThreadWorker.this, new String[]{"[Thread-" + this.threadNr + "]: " + "Start Login"});
                                soapResult = xogger.doLogin();
                                if (xogger.getClient().getSessionId() != null) break block22;
                                this.xogTableModel.setValueAt(new Integer(2), row, 1);
                                XogMultiThreadWorker.access$1(XogMultiThreadWorker.this, new String[]{"[Thread-" + this.threadNr + "]: " + "Error logging in"});
                                if (soapResult != null) {
                                    fResult = new File(XogMultiThreadWorker.access$3(XogMultiThreadWorker.this).getOutDir(), this.addTimeExtension(file.getName()));
                                    FileUtil.writeToFile(fResult, XOGSoapClient.getContent(soapResult, true));
                                    this.xogTableModel.setValueAt(fResult, row, 3);
                                    break;
                                }
                                ** GOTO lbl28
                            }
                            try {
                                XogMultiThreadWorker.access$1(XogMultiThreadWorker.this, new String[]{"[Thread-" + this.threadNr + "]: " + "Logged in succesfully"});
lbl28:
                                // 3 sources

                                XogMultiThreadWorker.access$1(XogMultiThreadWorker.this, new String[]{"[Thread-" + this.threadNr + "]: " + "xogging file: " + file});
                                soapResult = xogger.doXOG(file);
                                XogMultiThreadWorker.access$1(XogMultiThreadWorker.this, new String[]{"[Thread-" + this.threadNr + "]: " + "completed xogging file: " + file});
                                if (soapResult == null) continue;
                                FileUtil.writeToFile(new File(XogMultiThreadWorker.access$3(XogMultiThreadWorker.this).getOutDir(), this.addTimeExtension(file.getName())), XOGSoapClient.getContent(soapResult, true));
                                fResult = new File(XogMultiThreadWorker.access$3(XogMultiThreadWorker.this).getOutDir(), this.addTimeExtension(file.getName()));
                                this.xogTableModel.setValueAt(fResult, row, 3);
                                result = XOGSoapClient.getXOGresult(soapResult);
                                this.xogTableModel.getXogTable().get(row).setStatus(result.getOverallStatusIndication());
                                this.xogTableModel.getXogTable().get(row).setXogResult(result);
                                this.xogTableModel.fireTableRowsUpdated(row, row);
                            }
                            catch (Throwable t) {
                                this.xogTableModel.setValueAt(new Integer(2), row, 1);
                                XogMultiThreadWorker.access$1(XogMultiThreadWorker.this, new String[]{"[Thread-" + this.threadNr + "]: " + "Fatal Error " + t.toString()});
                                throw t;
                            }
                        }
                        finally {
                            this.xogTableModel.setValueAt(new Boolean(false), row, 0);
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (xogger != null) {
                        try {
                            XogMultiThreadWorker.access$1(XogMultiThreadWorker.this, new String[]{"[Thread-" + this.threadNr + "]: " + "Start Logout"});
                            xogger.doLogout();
                            XogMultiThreadWorker.access$1(XogMultiThreadWorker.this, new String[]{"[Thread-" + this.threadNr + "]: " + "Logout completed"});
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.latch.countDown();
                    return;
                }
            }
            catch (Throwable var9_14) {
                if (xogger != null) {
                    try {
                        XogMultiThreadWorker.access$1(XogMultiThreadWorker.this, new String[]{"[Thread-" + this.threadNr + "]: " + "Start Logout"});
                        xogger.doLogout();
                        XogMultiThreadWorker.access$1(XogMultiThreadWorker.this, new String[]{"[Thread-" + this.threadNr + "]: " + "Logout completed"});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.latch.countDown();
                throw var9_14;
            }
            if (xogger != null) {
                try {
                    XogMultiThreadWorker.access$1(XogMultiThreadWorker.this, new String[]{"[Thread-" + this.threadNr + "]: " + "Start Logout"});
                    xogger.doLogout();
                    XogMultiThreadWorker.access$1(XogMultiThreadWorker.this, new String[]{"[Thread-" + this.threadNr + "]: " + "Logout completed"});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.latch.countDown();
        }
    }
}

